package provide TclGPH 1.0

proc VtkLine { } {
   global WinInfo GphInfo XYZ XYZp XYZn GPHRender DevCt

   set wN $GphInfo(curWin)
   if [info exist GphInfo(VtkLine)] { 
      incr GphInfo(VtkLine) 
   } else { set GphInfo(VtkLine) 0 }
   set iD $GphInfo(VtkLine)

# NO line if less than two points so scram

   if { $XYZn < 2 } { return }

# SET up the linestyle

   switch -exact -- $GphInfo(lStyle) {
      SOLID      { set lStyle 65535 }
      DASH1      { set lStyle 43690 }
      DASH2      { set lStyle 56173 }
      DASH3      { set lStyle 61167 }
      DASH4      { set lStyle 63421 }
      SPDASH1    { set lStyle 52428 }
      SPDASH2    { set lStyle 58254 }
      SPDASH3    { set lStyle 61680 }
      SPDASH4    { set lStyle 65280 }
      DASHDOT1   { set lStyle 51603 }
      DASHDOT2   { set lStyle 58596 }
      DASHDOT3   { set lStyle 62073 }
      DASH2DOT1  { set lStyle 54699 }
      DASH2DOT2  { set lStyle 60138 }
      DASH2DOT3  { set lStyle 62842 }
      DASHSPDOT1 { set lStyle 51603 }
      DASHSPDOT2 { set lStyle 58596 }
      DASHSPDOT3 { set lStyle 62073 }
      default    { set lStyle 65535 }
   }



# SCALE all of the points in the line(s) and if necessay clip them to
#   keep them within the drawing window.  Separate by 2 and 3 dimensional
#   data.

   if { $WinInfo($wN,Dimen) == 2 } { 
      set J 0
      if { $WinInfo($wN,Clip) == 0 } {
         set Sx $WinInfo($wN,s0) ; set Ix $WinInfo($wN,i0) 
         set Sy $WinInfo($wN,s1) ; set Iy $WinInfo($wN,i1) 
         for { set I 0 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr $XYZ($J) * $Sx + $Ix] ; incr J
            set XYZ($J) [expr $XYZ($J) * $Sy + $Iy] ; incr J
         }
      } else {
         GPHlineClip 0
         for { set I 1 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
         }
      }

# NOW set up the points

      vtkPoints LinePoints$iD
         LinePoints$iD SetNumberOfPoints $XYZn
         set I 0
         set J 1
         for { set K 0 } { $K < $XYZn } { incr K ; incr I 2 ; incr J 2 } {
            LinePoints$iD InsertPoint $K $XYZ($I) $XYZ($J) 0
         }
   } else {
      set Sx $WinInfo($wN,s0) ; set Ix $WinInfo($wN,i0) 
      set Sy $WinInfo($wN,s1) ; set Iy $WinInfo($wN,i1) 
      set Sz $WinInfo($wN,s2) ; set Iz $WinInfo($wN,i2) 

      set J 0
      if { $WinInfo($wN,Clip) == 0 } {
         for { set I 0 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr $XYZ($J) * $Sx + $Ix] ; incr J
            set XYZ($J) [expr $XYZ($J) * $Sy + $Iy] ; incr J
            set XYZ($J) [expr $XYZ($J) * $Sz + $Iz] ; incr J
         }
      } else {
         GPHlineClip 0
         for { set I 1 } { $I < $XYZn } { incr I } {
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
            set XYZ($J) [expr int(floor($XYZ($J) + .5))] ; incr J
         }
      }

# NOW set up the points

      vtkPoints LinePoints$iD
         LinePoints$iD SetNumberOfPoints $XYZn
         if [string match OUT $GphInfo(3Dz)] {
            set I 0 ; set J 1 ; set L 2
         } else { set I 1 ; set J 2 ; set L 0 } 
         for { set K 0 } { $K < $XYZn } { incr K ; incr I 3 ; incr J 3 } {
            LinePoints$iD InsertPoint $K $XYZ($I) $XYZ($J) $XYZ($L) 
	    incr L 3
         }
   }

# CONNECT the dots

    vtkPolyLine LineSegs$iD
       [LineSegs$iD GetPointIds] SetNumberOfIds $XYZn
       for { set I 0 } { $I < $XYZn } { incr I } {
           [LineSegs$iD GetPointIds] SetId $I $I
       }

# CREATE the grid

    vtkUnstructuredGrid LineGrid$iD
       LineGrid$iD Allocate 1 1
       LineGrid$iD InsertNextCell [LineSegs$iD GetCellType] \
                                  [LineSegs$iD GetPointIds]
       LineGrid$iD SetPoints LinePoints$iD

# MAP the line

    vtkDataSetMapper LineMapper$iD
      LineMapper$iD SetInput LineGrid$iD

# GET the color components

    VtkFormColor $GphInfo(lColor) RGB

# SET up the line actor 
    vtkActor LineActor$iD
      LineActor$iD SetMapper LineMapper$iD
      [LineActor$iD GetProperty] SetDiffuseColor $RGB(0) $RGB(1) $RGB(2)
      [LineActor$iD GetProperty] SetLineStipplePattern $lStyle
                                                                                
# ADD the render

    GPHRender AddActor LineActor$iD

}
