package provide TclGPH 1.0

proc VtkInit { } {
   global DevInfo Prefs GphInfo  GPHRender GPHWindow GPHInteract

# READ the preference file if it hasn't already been read

   if ![info exists Prefs] { GUIprefsRead } 
#  set GphInfo(tFont) $Prefs(Font)

# SET up the screen designation

   if ![info exists GphInfo(CurScr)] { set GphInfo(CurScr) 0 }
   set sC Scr$GphInfo(CurScr)

# SET up the canvas size. This has been manually done by the calling program
#   or is read from an info file called data.VTK.  There is a fall back if
#   none of these have been done.

   set ScrLSet 0
   if [info exists GphInfo(xScrL)] {
      set X $GphInfo(xScrL)
      if [info exists GphInfo(yScrL)] {
         set Y $GphInfo(yScrL)
         if [info exists GphInfo(xsScrL)] {
            set Xs $GphInfo(xsScrL)
         } else { set Xs $X }
         if [info exists GphInfo(ysScrL)] {
            set Ys $GphInfo(ysScrL)
         } else { set Ys $Y }
         set ScrLSet 1
      }
   }

   if !$ScrLSet {
      set X 750 ; set Y 500
      set Xs 750 ; set Ys 500

      if { [file exists data.VTK] == 1 } {
         if [catch {open data.VTK r} input ] { 
         } else {
            gets $input line 
            scan $line "%s %d %d %d %d" Dev X Y Xs Ys
            if { [string match VTK $Dev] == 0 } {
               set X 750 ; set Y 500
               set Xs 750 ; set Ys 500
            }

	    set GphInfo(xScrL) $X
	    set GphInfo(yScrL) $Y
	    set GphInfo(xsScrL) $Xs
	    set GphInfo(ysScrL) $Ys
         }
      }
   }

   set X [expr int($X)]
   set Y [expr int($Y)]

   set DevInfo($sC.Width)  $X
   set DevInfo($sC.Heigth) $Y
   set DevInfo($sC.X)  $X
   set DevInfo($sC.Y)  $Y
   if { $X == $Y } { 
       set DevInfo($sC.Z) $X
   } else { set DevInfo($sC.Z) [expr int(sqrt($X * $X + $Y * $Y))] }
   set DevInfo($sC.Sx) 1.0
   set DevInfo($sC.Ix) 0.0
   set DevInfo($sC.Sy) 1.0
   set DevInfo($sC.Iy) 0.0
   set DevInfo($sC.Sz) 1.0
   set DevInfo($sC.Iz) 0.0
   if {$Y > $X } {
      set DevInfo($sC.SqX) [expr $Y / double($Xs)]
      set DevInfo($sC.SqY) 1.0
   } else {
      set DevInfo($sC.SqX) 1.0 
      set DevInfo($sC.SqY) [expr $X / double($Ys)]
   }

# CREATE the canvas in which all of the input will be drawn.  This conists
#   of setting up the Renderer, the window and the interactor.

   vtkRenderer GPHRender

   vtkRenderWindow GPHWindow
      GPHWindow AddRenderer GPHRender
      GPHWindow SetSize [expr $X -1] [expr $Y -1]

   vtkRenderWindowInteractor  GPHInteract
      GPHInteract SetRenderWindow GPHWindow

   vtkCamera GPHCamera
      GPHCamera SetFocalPoint [expr ($X -1)/2.0] [expr ($Y -1)/2.0] 0
      GPHCamera SetPosition [expr ($X -1)/2.0] [expr ($Y -1)/2.0] 1500

   GPHRender SetActiveCamera GPHCamera
   GPHRender ResetCamera
   GPHRender ResetCameraClippingRange
}
