package provide TclGPH 1.0

proc TkText { Just TexT Ang } {
   global WinInfo GphInfo XYZ DevCt DevInfo tcl_version

# SET up the screen designation and get plot canvas
 
   set vN [lindex [split $tcl_version "."] 1] 

   if ![info exists Ang] { set aN 0.0 } else { set aN [lindex $Ang 0] } 

   set sC Scr$GphInfo(CurScr)
   set sCr $DevInfo($sC).drw
   set wN $GphInfo(curWin)

   if { $WinInfo($wN,Clip) > 0 } {
      if { [GPHlineClip 0] == 0 } { return }
      set X $XYZ(0)
      set Y $XYZ(1)
   } else {
      set X [expr $XYZ(0) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set Y [expr $XYZ(1) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   }

   switch -exact -- $Just {
      right   { set J w }
      center  { set J center }
      left    { set J e }
      default { set J $Just }
   }

   if { [string first "#" $GphInfo(tColor)] >= 0 } {
      set tColor $GphInfo(tColor)
   } else { set tColor  $DevCt($GphInfo(tColor)) }

   if $GphInfo(revBC) {
      if [string match $tColor $GphInfo(sysBC)] {
         scan $tColor "#%02x%02x%02x" R G B
         set R [expr $R ^ 255]
         set G [expr $G ^ 255]
         set B [expr $B ^ 255]
         set tColor [format "#%02x%02x%02x" $R $G $B]
      }
   }


   if { $vN >= 6 } {
      set Fmt "-text {$TexT} -anchor $J -fill $tColor -angle $aN"
   } else { set Fmt "-text {$TexT} -anchor $J -fill $tColor" }
   append Fmt " -font {-family {$GphInfo(tFont)} -size $GphInfo(tSize) \
                       -weight $GphInfo(tBold) -slant $GphInfo(tItalics)}"
   if { [string length $GphInfo(tag)] != 0 } {
      append Fmt " -tag [lindex $GphInfo(tag) 0]"
      if { [llength $GphInfo(tag)] > 1 } { set GphInfo(tag) "" }
   }

   eval {$sCr create text} $X $Y $Fmt 
}
