package provide TclGPH 1.0

proc TkPoly { } {
   global WinInfo GphInfo XYZ XYZn DevCt DevInfo XYZp

# SET up the screen designation and get plot canvas

   set sC Scr$GphInfo(CurScr)
   set sCr $DevInfo($sC).drw
   set wN $GphInfo(curWin)

   if { [string first "#" $GphInfo(lColor)] >= 0 } {
      set lColor $GphInfo(lColor)
   } else { set lColor  $DevCt($GphInfo(lColor)) }

   if $GphInfo(revBC) {
      if [string match $lColor $GphInfo(sysBC)] {
         scan $lColor "#%02x%02x%02x" R G B
         set R [expr $R ^ 255]
         set G [expr $G ^ 255]
         set B [expr $B ^ 255]
         set lColor [format "#%02x%02x%02x" $R $G $B]
      }
   }

   set Fmt "-outline $lColor"

   if ![string match OFF $GphInfo(fColor) ] {
      if { [string first "#" $GphInfo(fColor)] >= 0 } {
         set fColor $GphInfo(fColor)
      } else { set fColor  $DevCt($GphInfo(fColor)) }

      if $GphInfo(revBC) {
         if [string match $fColor $GphInfo(sysBC)] {
            scan $fColor "#%02x%02x%02x" R G B
            set R [expr $R ^ 255]
            set G [expr $G ^ 255]
            set B [expr $B ^ 255]
            set fColor [format "#%02x%02x%02x" $R $G $B]
         }
      }

      append Fmt " -fill $fColor"
   }

   if { [string length $GphInfo(tag)] != 0 } {
      append Fmt " -tag [lindex $GphInfo(tag) 0]"
      if { [llength $GphInfo(tag)] > 1 } { set GphInfo(tag) "" }
   }

   set J 0 ; set K 1 ; set dI $WinInfo($wN,Dimen) 

   if { $WinInfo($wN,Clip) > 0 } { 
      GPHlineClip 1
      if { $XYZn < 3 } { return }

      set LiNe ""
      for { set I 0 } { $I < $XYZn } { incr I ; incr J $dI ; incr K $dI} {
         set X [expr floor($XYZ($J) + .5)]
         set Y [expr floor($XYZ($K) + .5)]
         lappend LiNe $X $Y
      }

      eval {$sCr create poly} $LiNe $Fmt
   } else {
      if { $XYZn < 3 } { return }
      set LiNe ""
      for { set I 0 } { $I < $XYZn } { incr I ; incr J $dI ; incr K $dI} {
         set X [expr $XYZ($J) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
         set Y [expr $XYZ($K) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
         lappend LiNe $X $Y
      }

      eval {$sCr create poly} $LiNe $Fmt
   }
}
