package provide TclGPH 1.0

proc TkInit { { CaNVaS NONE } } {
   global DevInfo Prefs GphInfo

# READ the preference file if it hasn't already been read

   if ![info exists Prefs] { GUIprefsRead } 
   set GphInfo(tFont) $Prefs(Font)

# SET up the screen designation

   if ![info exists GphInfo(CurScr)] { set GphInfo(CurScr) 0 }
   set sC Scr$GphInfo(CurScr)

# OK split the open into two different branches.  In the first branch
# the user specifies a pre-existing canvas in which to do the plot.  In
# second we will create the canvas.

   if ![string match NONE $CaNVaS] {
      set pAr $CaNVaS
      set sCr $CaNVaS.drw
      set DevInfo($sC) $CaNVaS
      set InFo [$sCr configure -width] 
      set Last [expr [llength $InFo] - 1]
      set X [lindex $InFo $Last]
      set InFo [$sCr configure -height] 
      set Last [expr [llength $InFo] - 1]
      set Y [lindex $InFo $Last]
      set InFo [$sCr configure -scrollregion]
      set Last [expr [llength $InFo] - 1]
      set Xs [lindex [lindex $InFo $Last] 2]
      set Ys [lindex [lindex $InFo $Last] 3]
      if { [string length $Xs] == 0 } { set Xs $X }
      if { [string length $Ys] == 0 } { set Ys $Y }
   } else {
      set ScrLSet 0
      if [info exists GphInfo(xScrL)] {
         set X $GphInfo(xScrL)
         if [info exists GphInfo(yScrL)] {
            set Y $GphInfo(yScrL)
            if [info exists GphInfo(xsScrL)] {
               set Xs $GphInfo(xsScrL)
            } else { set Xs $X }
            if [info exists GphInfo(ysScrL)] {
               set Ys $GphInfo(ysScrL)
            } else { set Ys $Y }
            set ScrLSet 1
         }
      }

      if !$ScrLSet {
         set X 750
         set Y 500
         set Xs 750
         set Ys 500

         if { [file exists data.TK] == 1 } {
            if [catch {open data.TK r} input ] { 
            } else {
               gets $input line 
               scan $line "%s %d %d %d %d" Dev X Y Xs Ys
               if { [string match TK $Dev] == 0 } {
                  set X 750
                  set Y 500
                  set Xs 750
                  set Ys 500
               }
            }
         }

	 set GphInfo(xScrL) $X
	 set GphInfo(yScrL) $Y
	 set GphInfo(xsScrL) $Xs
	 set GphInfo(ysScrL) $Ys
      }
   
      set pAr .pLoT$GphInfo(CurScr)
      set sCr $pAr.drw
      set DevInfo($sC) $pAr
      if [winfo exists $pAr] { destroy $pAr }
      toplevel $pAr
      GUIFrame $pAr.top
      grid $pAr.top -sticky ew

      if { ($X == $Xs) && ($Y == $Ys) } {
         eval { canvas $sCr -highlightthickness 0 -borderwidth 0 \
                 -height $Y -width $X -background black }
         grid $sCr -sticky news
      } elseif { $X == $Xs } {
         eval {canvas $sCr \
           -yscrollcommand [list $pAr.yscroll set] \
           -highlightthickness 0 -borderwidth 0 \
           -height $Y -width $X -background black \
	   -scrollregion "0 0 $Xs $Ys" }
         scrollbar $pAr.yscroll -orient vertical -command [list $sCr yview]
         grid $sCr $pAr.yscroll -sticky news
         grid rowconfigure $pAr 0 -weight 1
         grid columnconfigure $pAr 0 -weight 1
      } elseif { $Y == $Ys } {
         eval {canvas $sCr \
           -xscrollcommand [list $pAr.xscroll set] \
           -highlightthickness 0 -borderwidth 0 \
           -height $Y -width $X -background black \
	   -scrollregion "0 0 $Xs $Ys" }
         scrollbar $pAr.xscroll -orient horizontal -command [list $sCr xview]
         grid $sCr -sticky news
         grid $pAr.xscroll -sticky ew
         grid rowconfigure $pAr 0 -weight 1
         grid columnconfigure $pAr 0 -weight 1
      } else {
         eval {canvas $sCr \
           -xscrollcommand [list $pAr.xscroll set] \
           -yscrollcommand [list $pAr.yscroll set] \
           -highlightthickness 0 -borderwidth 0 \
           -height $Y -width $X -background black \
	   -scrollregion "0 0 $Xs $Ys" }
         scrollbar $pAr.xscroll -orient horizontal -command [list $sCr xview]
         scrollbar $pAr.yscroll -orient vertical -command [list $sCr yview]
         grid $sCr $pAr.yscroll -sticky news
         grid $pAr.xscroll -sticky ew
         grid rowconfigure $pAr 0 -weight 1
         grid columnconfigure $pAr 0 -weight 1
      }

      GUIbuttonPush $pAr.top.quit EXIT pack|left "exit" 6 10 
      if [info exists GphInfo(CLOSE)] {
         set FunC "$GphInfo(CLOSE) $pAr"
      } else { set FunC "destroy $pAr" }
      GUIbuttonPush $pAr.top.close CLOSE pack|right $FunC 6 10 
      if [info exists GphInfo(ACTIVE)] {
         set FunC "$GphInfo(ACTIVE)"
      } else { set FunC "" }
      GUIbuttonPush $pAr.top.status ACTIVE pack|right $FunC 6 10 
      $sCr config -cursor crosshair
   } 

   set DevInfo($sC.Width)  $X
   set DevInfo($sC.Heigth) $Y
   set DevInfo($sC.X)  $Xs
   set DevInfo($sC.Y)  $Ys
   set DevInfo($sC.Sx) 1.0
   set DevInfo($sC.Ix) 0.0
   set DevInfo($sC.Sy) -1.0
   set DevInfo($sC.Iy) $Ys
   if {$Y > $X } {
      set DevInfo($sC.SqX) [expr $Y / double($Xs)]
      set DevInfo($sC.SqY) 1.0
   } else {
      set DevInfo($sC.SqX) 1.0 
      set DevInfo($sC.SqY) [expr $X / double($Ys)]
   }

   set DevInfo($sC.YDir) <

   set DevInfo($sC.mS) 0
#  bind $sCr <Button-1> {TkMouse %W %x %y}
#  bind $sCr <Button-3> {GetTime}

}
