# WinInfo(wN,posFmt) = 0 lower left hand corner fixed Len along X
# WinInfo(wN,posFmt) = 1 lower left hand corner fixed Len along Y
# WinInfo(wN,posFmt) = 2 center fixed Len along X
# WinInfo(wN,posFmt) = 3 center fixed Len along Y

package provide TclGPH 1.0

proc SqWindow {wN rX1 rY1 rZ1 Len sX1 sY1 sZ1 sX2 sY2 sZ2 {Add N} } {
   global WinInfo GphInfo DevInfo

# SET up the screen designation

   set sC Scr$GphInfo(CurScr)

   set GphInfo(curWin) $wN
   GPHinits WINDOW $wN

   set rV [GPHmapLims $sX1 $sY1 $sX2 $sY2]
   set sX1 [lindex $rV 0] ; set sY1 [lindex $rV 1]
   set sX2 [lindex $rV 2] ; set sY2 [lindex $rV 3]

   if { $Len > 1.0 } { set $Len 1.0 }

   set WinInfo($wN,Type) 2
   if { $sZ1 == $sZ2 } {
      set WinInfo($wN,Dimen) 2
   } else { set WinInfo($wN,Dimen) 3 }

   if ![expr $WinInfo($wN,posFmt) % 2] {
      set tY $Len
      if { $DevInfo($sC.SqY) == 1.0 } {
         set tX [ expr $Len * $DevInfo($sC.SqX)]
      } else { set tX [expr $Len / $DevInfo($sC.SqY)] }
   } else {
      set tX $Len 
      if { $DevInfo($sC.SqX) == 1.0 } {
         set tY [ expr $Len * $DevInfo($sC.SqY)]
      } else { set tY [ expr $Len / $DevInfo($sC.SqX)] }
   }

   set Ratio [expr $tX / $tY]

   switch -exact -- $WinInfo($wN,posFmt) {
      0 -
      1 {
         set rX2 [expr $rX1 + $tX]
	 if { $rX2 > 1.0 } {
	    set tX [expr 1.0 - $rX1]
	    set tY [expr $tX / $Ratio]
         }
         set rY2 [expr $rY1 + $tY]
	 if { $rY2 > 1.0 } {
	    set tY [expr 1.0 - $rY1]
	    set tX [expr $tY * $Ratio]
         }
      }
      2 -
      3 {
         set dX [ expr $rX1 - $tX / 2.0]
	 if { $dX < 0.0 } {
	    set tX [expr $rX1 * 2.0]
	    set tY [expr $tX / $Ratio]
         }
         set dY [expr $rY1 - $tY / 2.0]
	 if { $dY < 0.0 } {
	    set tY [expr $rY1 * 2.0]
	    set tX [expr $tY * $Ratio]
         }

         set dX [ expr $rX1 + $tX / 2.0]
	 if { $dX > 1.0 } {
	    set tX [expr (1.0 - $rX1) * 2.0]
	    set tY [expr $tX / $Ratio]
         }
         set dY [expr $rY1 + $tY / 2.0]
	 if { $dY > 1.0 } {
	    set tY [expr (1.0 - $rY1) * 2.0]
	    set tX [expr $tY * $Ratio]
         }

         set rX1 [ expr $rX1 - $tX / 2.0]
         set rY1 [ expr $rY1 - $tY / 2.0]
      }
      4 -
      5 {
         set dX [expr $rX1 - $tX]
	 if { $dX < 0.0 } {
	    set tX $rX1
	    set tY [expr $tX / $Ratio]
         }
         set dY [expr $rY1 - $tY]
	 if { $dY < 0.0 } {
	    set tY $rY1
	    set tX [expr $tY * $Ratio]
         }
         set rX1 [expr $rX1 - $tX]
         set rY1 [expr $rY1 - $tY]
      }
   }

   set rX2 [expr $rX1 + $tX]
   set rY2 [expr $rY1 + $tY]
   set rZ2 $rX2

   set WinInfo($wN,r0) $rX1
   set WinInfo($wN,r1) $rY1
   set WinInfo($wN,r2) $rZ1
   set WinInfo($wN,r3) $rX2
   set WinInfo($wN,r4) $rY2
   set WinInfo($wN,r5) $rZ2

   set WinInfo($wN,pp0) $sX1 ; set WinInfo($wN,sp0) $sX1
   set WinInfo($wN,pp1) $sY1 ; set WinInfo($wN,sp1) $sY1
   set WinInfo($wN,pp2) $sZ1 ; set WinInfo($wN,sp2) $sZ1
   set WinInfo($wN,pp3) $sX2 ; set WinInfo($wN,sp3) $sX2
   set WinInfo($wN,pp4) $sY2 ; set WinInfo($wN,sp4) $sY2
   set WinInfo($wN,pp5) $sZ2 ; set WinInfo($wN,sp5) $sZ2

   GPHwinScale $wN Xp Yp Zp 3

   if { $WinInfo($wN,pa0) == 1 } {
      set V [expr log10($WinInfo($wN,pp0)) ]
      set X1 [expr $V * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set V [expr log10($WinInfo($wN,pp3)) ]
      set X2 [expr $V * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
   } else {
      set X1 [expr $WinInfo($wN,pp0) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set X2 [expr $WinInfo($wN,pp3) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
   }

#
#  Get the pixel locations of the Y corners of the window
#

   if { $WinInfo($wN,pa1) == 1 } {
      set V [expr log10($WinInfo($wN,pp1)) ]
      set Y1 [expr $V * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
      set V [expr log10($WinInfo($wN,pp4)) ]
      set Y2 [expr $V * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   } else {
      set Y1 [expr $WinInfo($wN,pp1) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
      set Y2 [expr $WinInfo($wN,pp4) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   }

   if { $Y1 > $Y2 } {
      set TmP $Y1
      set Y1 $Y2
      set Y2 $TmP
   }

   set X1 [expr floor($X1 + .5)]  
   set Y1 [expr floor($Y1 + .5)]
   set X2 [expr floor($X2 + .5)]  
   set Y2 [expr floor($Y2 + .5)]

   set WinInfo($wN.SqX) 1.0
   set WinInfo($wN.SqY) 1.0

   set WinInfo($wN,b) [list $X1 $Y1 $X2 $Y2]
   set WinInfo($wN,px) $Add
   switch -exact -- $Add {
      X   {  set WinInfo($wN,pp0) 0
             set WinInfo($wN,pp3) [expr $X2 - $X1]
             set WinInfo($wN,sp0) 0
             set WinInfo($wN,sp3) [expr $X2 - $X1]
             GPHwinScale $wN Xp Yp Zp 0
          }
      Y   {  set WinInfo($wN,pp1) 0
             set WinInfo($wN,pp4) [expr $Y2 - $Y1]
             set WinInfo($wN,sp1) 0
             set WinInfo($wN,sp4) [expr $Y2 - $Y1]
             GPHwinScale $wN Xp Yp Zp 0
          }
      XY  {  set WinInfo($wN,pp0) 0
             set WinInfo($wN,pp3) [expr $X2 - $X1]
             set WinInfo($wN,pp1) 0
             set WinInfo($wN,pp4) [expr $Y2 - $Y1]
             set WinInfo($wN,sp0) 0
             set WinInfo($wN,sp3) [expr $X2 - $X1]
             set WinInfo($wN,sp1) 0
             set WinInfo($wN,sp4) [expr $Y2 - $Y1]
             GPHwinScale $wN Xp Yp Zp 0
          }
   }
}
