package provide TclGPH 1.0

proc GenWindow {wN rX1 rY1 rZ1 rX2 rY2 rZ2 sX1 sY1 sZ1 sX2 sY2 sZ2 {Pix N} } {
   global WinInfo GphInfo

   set GphInfo(curWin) $wN

   GPHinits WINDOW $wN

   set rV [GPHmapLims $sX1 $sY1 $sX2 $sY2]
   set sX1 [lindex $rV 0] ; set sY1 [lindex $rV 1]
   set sX2 [lindex $rV 2] ; set sY2 [lindex $rV 3]

   set WinInfo($wN,Type) 1
   if { $sZ1 == $sZ2 } {
      set WinInfo($wN,Dimen) 2
   } else { set WinInfo($wN,Dimen) 3 }

   if { $WinInfo($wN,posFmt) == 1 } {
      set WinInfo($wN,r0) [expr $rX1 - $rX2 / 2.0]
      set WinInfo($wN,r1) [expr $rY1 - $rY2 / 2.0]
      set WinInfo($wN,r2) [expr $rZ1 - $rZ2 / 2.0]
      set WinInfo($wN,r3) [expr $rX1 + $rX2 / 2.0]
      set WinInfo($wN,r4) [expr $rY1 + $rY2 / 2.0]
      set WinInfo($wN,r5) [expr $rZ1 + $rZ2 / 2.0]
   } else {
      set WinInfo($wN,r0) $rX1
      set WinInfo($wN,r1) $rY1
      set WinInfo($wN,r2) $rZ1
      if { $WinInfo($wN,disFmt) == 1 } {
         set WinInfo($wN,r3) [expr $rX1 + $rX2]
         set WinInfo($wN,r4) [expr $rY1 + $rY2]
         set WinInfo($wN,r5) [expr $rZ1 + $rZ2]
      } else {
         set WinInfo($wN,r3) $rX2
         set WinInfo($wN,r4) $rY2
         set WinInfo($wN,r5) $rZ2
      }
   }

   set J 3
   for { set I 0 } { $I < 3 } { incr I; incr J } {
      if { $WinInfo($wN,r$I) < 0.0 } { set WinInfo($wN,r$I) 0.0 }
      if { $WinInfo($wN,r$J) > 1.0 } { set WinInfo($wN,r$J) 1.0 }
   }

   set WinInfo($wN,pp0) $sX1 ; set WinInfo($wN,sp0) $sX1
   set WinInfo($wN,pp1) $sY1 ; set WinInfo($wN,sp1) $sY1
   set WinInfo($wN,pp2) $sZ1 ; set WinInfo($wN,sp2) $sZ1
   set WinInfo($wN,pp3) $sX2 ; set WinInfo($wN,sp3) $sX2
   set WinInfo($wN,pp4) $sY2 ; set WinInfo($wN,sp4) $sY2
   set WinInfo($wN,pp5) $sZ2 ; set WinInfo($wN,sp5) $sZ2

   GPHwinScale $wN Xp Yp Zp 3

   if { $WinInfo($wN,pa0) == 1 } {
      set V [expr log10($WinInfo($wN,pp0)) ]
      set X1 [expr $V * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set V [expr log10($WinInfo($wN,pp3)) ]
      set X2 [expr $V * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
   } else {
      set X1 [expr $WinInfo($wN,pp0) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set X2 [expr $WinInfo($wN,pp3) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
   }

#
#  Get the pixel locations of the Y corners of the window
#

   if { $WinInfo($wN,pa1) == 1 } {
      set V [expr log10($WinInfo($wN,pp1)) ]
      set Y1 [expr $V * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
      set V [expr log10($WinInfo($wN,pp4)) ]
      set Y2 [expr $V * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   } else {
      set Y1 [expr $WinInfo($wN,pp1) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
      set Y2 [expr $WinInfo($wN,pp4) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   }

   if { $Y1 > $Y2 } {
      set TmP $Y1
      set Y1 $Y2
      set Y2 $TmP
   }

   set X1 [expr floor($X1 + .5)]  
   set Y1 [expr floor($Y1 + .5)]
   set X2 [expr floor($X2 + .5)]  
   set Y2 [expr floor($Y2 + .5)]

   set dX [expr $X2 - $X1]
   set dY [expr $Y2 - $Y1]
   if {$dY > $dX } {
      set WinInfo($wN.SqX) [expr $dY / double($dX)]
      set WinInfo($wN.SqY) 1.0
   } else {
      set WinInfo($wN.SqX) 1.0
      set WinInfo($wN.SqY) [expr $dX / double($dY)]
   }

   set WinInfo($wN,b) [list $X1 $Y1 $X2 $Y2]
   set WinInfo($wN,px) $Pix
   switch -exact -- $Pix {
      X   {  set WinInfo($wN,pp0) 0
             set WinInfo($wN,pp3) [expr $X2 - $X1]
             set WinInfo($wN,sp0) 0
             set WinInfo($wN,sp3) [expr $X2 - $X1]
             GPHwinScale $wN Xp Yp Zp 0
          }
      Y   {  set WinInfo($wN,pp1) 0
             set WinInfo($wN,pp4) [expr $Y2 - $Y1]
             set WinInfo($wN,sp1) 0
             set WinInfo($wN,sp4) [expr $Y2 - $Y1]
             GPHwinScale $wN Xp Yp Zp 0
          }
      XY  {  set WinInfo($wN,pp0) 0
             set WinInfo($wN,pp3) [expr $X2 - $X1]
             set WinInfo($wN,pp1) 0
             set WinInfo($wN,pp4) [expr $Y2 - $Y1]
             set WinInfo($wN,sp0) 0
             set WinInfo($wN,sp3) [expr $X2 - $X1]
             set WinInfo($wN,sp1) 0
             set WinInfo($wN,sp4) [expr $Y2 - $Y1]
             GPHwinScale $wN Xp Yp Zp 0
          }
   }
}
