package provide TclGPH 1.0

proc GPHwinScale {wN X Y Z Action } {
   global WinInfo GphInfo DevInfo

# SET up the screen designation

   set sC Scr$GphInfo(CurScr)

   if ![string match Xc $X ] {
      if [string match Xs $X ] {
         set WinInfo($wN,a0) $WinInfo($wN,sa0) 
         set WinInfo($wN,p0) $WinInfo($wN,sp0) 
         set WinInfo($wN,p3) $WinInfo($wN,sp3) 
      } else {
         set WinInfo($wN,a0) $WinInfo($wN,pa0) 
         set WinInfo($wN,p0) $WinInfo($wN,pp0) 
         set WinInfo($wN,p3) $WinInfo($wN,pp3) 
      }
      set WinInfo($wN,X) $X
   }

   if ![string match Yc $Y ] {
      if [string match Ys $Y ] {
         set WinInfo($wN,a1) $WinInfo($wN,sa1) 
         set WinInfo($wN,p1) $WinInfo($wN,sp1) 
         set WinInfo($wN,p4) $WinInfo($wN,sp4) 
      } else {
         set WinInfo($wN,a1) $WinInfo($wN,pa1) 
         set WinInfo($wN,p1) $WinInfo($wN,pp1) 
         set WinInfo($wN,p4) $WinInfo($wN,pp4) 
      }
      set WinInfo($wN,Y) $Y
   }

   if ![string match Zc $Z ] {
      if [string match Zs $Z ] {
         set WinInfo($wN,a2) $WinInfo($wN,sa2) 
         set WinInfo($wN,p2) $WinInfo($wN,sp2) 
         set WinInfo($wN,p5) $WinInfo($wN,sp5) 
      } else {
         set WinInfo($wN,a2) $WinInfo($wN,pa2) 
         set WinInfo($wN,p2) $WinInfo($wN,pp2) 
         set WinInfo($wN,p5) $WinInfo($wN,pp5) 
      }
      set WinInfo($wN,Z) $Z
   }

   if { $GphInfo(oStyle) > 0 } { 
      if { [expr $Action & 1] == 1} {
          set TmP  $WinInfo($wN,r0)
          set WinInfo($wN,r0) [expr 1.0 - $WinInfo($wN,r3)]
          set WinInfo($wN,r3) [expr 1.0 - $TmP]
      } 
      if { [expr $Action & 2] == 2} {
          set TmP  $WinInfo($wN,p0)
          set WinInfo($wN,p0) $WinInfo($wN,p3)
          set WinInfo($wN,p3) $TmP
      } 
   }

   set x1 [expr int($WinInfo($wN,r0) * ($DevInfo($sC.X) - 1.0))]
   set x2 [expr int($WinInfo($wN,r3) * ($DevInfo($sC.X) - 1.0))]

   if { $x1 == $x2 } { return -1 }
   if { $WinInfo($wN,a0) == 1 } {
      if { ($WinInfo($wN,p0) > 0.0) && ($WinInfo($wN,p3) > 0.0) } { 
         set Max [expr log10($WinInfo($wN,p3))]
         set TmP [expr $Max - log10($WinInfo($wN,p0)) ]
      } else { return 0 }
   } else {
      set TmP [expr double($WinInfo($wN,p3) - $WinInfo($wN,p0)) ]
      set Max $WinInfo($wN,p3)
   }
   set A [expr ($x2 - $x1) / $TmP]
   set B [expr $x2 - $Max * $A]
   set WinInfo($wN,s0) [expr $A * $DevInfo($sC.Sx)]
   set WinInfo($wN,i0) [expr $B * $DevInfo($sC.Sx) + $DevInfo($sC.Ix)]

   set y1 [expr int($WinInfo($wN,r1) * ($DevInfo($sC.Y) - 1.0))]
   set y2 [expr int($WinInfo($wN,r4) * ($DevInfo($sC.Y) - 1.0))]
   if {$y1 == $y2 } { return -1 }
   if { $WinInfo($wN,a1) == 1 } {
      if { ($WinInfo($wN,p1) > 0.0) && ($WinInfo($wN,p4) > 0.0) }  {
         set Max [expr log10($WinInfo($wN,p4))]
         set TmP [expr $Max - log10($WinInfo($wN,p1)) ]
      } else { return 0 }
   } else {
      set TmP [expr double($WinInfo($wN,p4) - $WinInfo($wN,p1)) ]
      set Max $WinInfo($wN,p4)
   }

   set A [expr ($y2 - $y1) / $TmP]
   set B  [expr $y2 - $Max * $A]
   set WinInfo($wN,s1) [expr $A * $DevInfo($sC.Sy)]
   set WinInfo($wN,i1) [expr $B * $DevInfo($sC.Sy) + $DevInfo($sC.Iy)]

   if { $WinInfo($wN,Dimen) == 3 } {
      set z1 [expr int($WinInfo($wN,r2) * ($DevInfo($sC.Z) - 1.0))]
      set z2 [expr int($WinInfo($wN,r5) * ($DevInfo($sC.Z) - 1.0))]
      if { $z1 == $z2 } { return -1 }
      if { $WinInfo($wN,a2) == 1 } {
         if { ($WinInfo($wN,p2) > 0.0) && ($WinInfo($wN,p5) > 0.0) } { 
            set Max [expr log10($WinInfo($wN,p5))]
            set TmP [expr $Max - log10($WinInfo($wN,p2)) ]
         } else { return 0 }
      } else {
         set TmP [expr double($WinInfo($wN,p5) - $WinInfo($wN,p2)) ]
         set Max $WinInfo($wN,p5)
      }
      set A [expr ($z2 - $z1) / $TmP]
      set B [expr $z2 - $Max * $A]
      set WinInfo($wN,s2) [expr $A * $DevInfo($sC.Sz)]
      set WinInfo($wN,i2) [expr $B * $DevInfo($sC.Sz) + $DevInfo($sC.Iz)]
   }
}
