package provide TclGPH 1.0

# THIS procedure determines the actual cartesian window limits for different
#    coordinate systems.  There are bassically three types of mappings: 1)
#    those which map to a rectangular coordinate system (like MERCATOR or
#    CYLINDRICAL), 2) Those which map to a spherical coordinate system (like
#    SINUSOIDAL or ELLIPTICAL(, 3) and those which do neither (like 
#    STEREOGRAPHIC or ORTHOGRAPHIC).
#
#    The latter type have custom settings.  The first type have the corners
#    set directly from the window corners.  The middle type have the X cornors
#    set from the maximum phi at 0 degrees Theta and Y cornors set from the 
#    minimum Theta at the maximum Phi.

proc GPHmapLims { sX1 sY1 sX2 sY2 } {
   global WinInfo GphInfo

# CARTESIAN is just a pass through

   if [string match CARTESIAN $GphInfo(CoSyS)] {
      set rV [list $sX1 $sY1 $sX2 $sY2]
      return $rV
   }

# GET the absolute minimum Y and maxumum X

   if { [expr abs($sX1)] > [expr abs($sX2)] } { 
      set tX [expr abs($sX1)] 
   } else { set tX [expr abs($sX2)] } 

   if {  [expr abs($sY1)] > [expr abs($sY2)] } { 
      set tY [expr abs($sY2)] 
   } else { set tY [expr abs($sY1)] } 

   set aX(0) [expr -1.0 * $tX] ; set aY(0) 0.0 
   set aX(1) [expr -1.0 * $tX] ; set aY(1) [expr -1.0 * $tY]
   set aX(2) $tX ; set aY(2) 0.0 
   set aX(3) $tX ; set aY(3) $tY 

# STANDARD X Y
#
   set Lat(0) $sX1 ; set Lat(1) $sX2 
   set Lng(0) $sY1 ; set Lng(1) $sY2

   switch -exact -- $GphInfo(CoSyS) {
      EQUIRECTANGULAR -
      MERCATOR - 
      CYLINDRICAL_EQUIDISTANT -  
      CYLINDRICAL_EQUAL_AREA -  
      LAMBERT_CYLINDRICAL -  
      BEHRMANN_CYLINDRICAL -
      TRISTAN_EDWARDS -
      PETERS -
      GALL_ORTHOGRAPHIC -
      BALTHASART -
      MILLER37 -
      MILLER43 -
      MILLER50 -
      CYLINDRICAL { 
         GPHmapXY $GphInfo(CoSyS) 2 Lat Lng X Y S 0 $GphInfo(CsOps)
         set rV [list $X(0) $Y(0) $X(1) $Y(1)] 
      }
      ORTHOGRAPHIC { set rV [list -1.0 -1.0 1.0 1.0] }
      STEREOGRAPHIC { set rV [list -4.5 -2.3 4.6 2.3] } 
      POLAR { set rV [list [expr -1.0 * $tX] [expr -1.0 * $tX] $tX $tX] }
      ECKERT_SINUSOIDAL -
      ECKERT_ELLIPSOIDAL -
      MOLLWEIDE -
      SINUSOIDAL {
         GPHmapXY $GphInfo(CoSyS) 4 aX aY X Y S 0 $GphInfo(CsOps)
         set rV [list $X(0) $Y(1) $X(2) $Y(3)] 
      }
   }

   return $rV
}
