package provide TclGPH 1.0

#
#   This function keeps track of the movement of a polygon which is
#   being drawn outside of the current window.  The drawing is
#   tracked by keeping track of the sectors throught which the
#   polygon has passed.  These sectors are defined in the drawing
#   below.
#
#                          +            +
#                        7 +      6     + 5
#                      ++++++++++++++++++++++
#                          +            +
#                          +            +
#                        0 +   window   + 4
#                          +            +
#                          +            +
#                      ++++++++++++++++++++++
#                        1 +      2     + 3
#                          +            +
#

proc GPHclipOut { Quad Qcnt Bnd X Y } {

    upvar $Quad Q
    upvar $Bnd B

#  Get the sector of the point (x,y)

   if { $X <= $B(0) } {
      if { $Y > $B(3) } {
         set Loc 7
      } elseif { $Y < $B(1) } { set Loc 1 } else { set Loc 0 }
   } elseif { $X >= $B(2) } {
      if { $Y > $B(3) } {
         set Loc 5
      } elseif { $Y < $B(1) } { set Loc 3 } else { set Loc 4 }
   } elseif { $Y >= $B(3) } {
      if { $X > $B(2) } {
         set Loc 5
      } elseif { $X < $B(0) } { set Loc 7 } else { set Loc 6 }
   } else {
      if { $X > $B(2) } {
         set Loc 3
      } elseif { $X < $B(0) } { set Loc 1 } else { set Loc 2 }
   }

#
#                             IF
#      this is the first point in the quadrant array then
#      store this sector location in the first element
#                            ELSE
#      get the location of the last entered element.  Form the
#      the difference between this sector and the last stored
#                             IF
#         the two sectors are the same then no need to add
#         this point
#                            ELSE
#         begin the treatment of this point.
#                             IF
#            the delta is not 1 - that is if the polygon
#            has passed through more than one sector then
#            compute the following:
#              qNext: the next counter-clockwise quadrant number
#              qN: the next clockwise quadrant number
#              temp: the next clockwise quadrant  after a
#           Now it current quadrant is same as temp then the
#           polygon has moved clockwise through a to temp and
#           both the a and temp quadrants must be added to the
#           quadrant array.  Otherwise the polygon had moved
#           counter-clockwise through b and both b and loc are
#           added to the quandrant array
#                            ELSE
#           the point has moved one quadrant away and that
#           quadrant is added to the quadrant array
#
#        The quandrant array is filled
   
   if { $Qcnt == 0 } {
      set Q($Qcnt) $Loc
      incr Qcnt
   } else {
      set Cnt [expr $Qcnt - 1]
      set LQuad $Q($Cnt)
      set Delta [expr abs($LQuad - $Loc)]

      if { $Delta != 0 } {
         if { ($Delta > 1) && ($Delta < 7) } {
            set qNext  [ expr ($LQuad + 1) % 8]
            if { $LQuad == 0 } { set qN 0 } else { set qN [expr $LQuad - 1] }
            if { $qN == 0 } { set TmP 7 } else { set TmP [expr $qN - 1] }
            if { $Loc == $TmP } { set T(0) $qN } else { set T(0) $qNext }
            set T(1) $Loc
            set Terms 2
         } else {
            set Terms 1
            set T(0) $Loc
         }
         
         for { set I 0 } { $I < $Terms } { incr I } {
            if { $Qcnt > 1 } { 
               if { ($Q([expr $Qcnt - 2]) == $T($I)) } { 
                  set Q($Qcnt) -1
                  incr Qcnt -1 
               } else {
                  set Q($Qcnt) $T($I)
                  incr Qcnt
               }
            } else {
               set Q($Qcnt) $T($I)
               incr Qcnt
            }
         }
      }
   }

   if { $Qcnt > 8 } {set Qcnt 8 }

   return $Qcnt
}
