#  Clip_it takes a line formed from two points and determines
#  if it must be clipped.  If so, it performs the clipping.
#  The input parameters are:
#
#     r1    - The input data points (x1,y1,x2,y2)
#     r2    - The possibly clipped output data point in the
#             same format (x1,y1,x2,y2)

package provide TclGPH 1.0

proc GPHclipIt { In Out Quad Qc Bnd Two } {
     global left1 up1 right1 down1 left2 up2 right2 down2

     upvar $In R1
     upvar $Out R2
     upvar $Quad Q
     upvar $Bnd B
     upvar $Qc Qcnt

#    set Qcnt 0
     set ClipOn 0

     for { set I 0 } { $I < 4 } { incr I } { set R2($I) $R1($I) }

#  Check to see if second data point is within the clipped region.  This is 
#  done as 4 separate checks.  The x coor. against the left and right x 
#  boundaries and the y coor. against the upper and lower y boundaries. Note 
#  that the second point in the pair is always NEW!

    if { $R1(2) >= $B(0) } { set left2 1 } else { set left2 0 }
    if { $R1(3) >= $B(1) } { set down2 1 } else { set down2 0 }
    if { $R1(2) <= $B(2) } { set right2 1 } else { set right2 0 }
    if { $R1(3) <= $B(3) } { set up2 1 } else { set up2 0 }

    set Sum2 [expr $left2 + $right2 + $up2 + $down2]

#   If the first point in the pair was not already checked as the last point 
#   in the previous line (polyline scenario) then check it also just as 
#   second point was checked.

    if {$Two == 1 } {
       if { $R1(0) >= $B(0) } { set left1 1 } else { set left1 0 }
       if { $R1(1) >= $B(1) } { set down1 1 } else { set down1 0 }
       if { $R1(0) <= $B(2) } { set right1 1 } else { set right1 0 }
       if { $R1(1) <= $B(3) } { set up1 1 } else { set up1 0 }
    }

    set Sum1 [expr $left1 + $right1 + $up1 + $down1]

#  Now if both points are within the clipping region then we're outta here

   if { ( $Sum1 == 4 ) && ( $Sum2 == 4) } { return [list $ClipOn $Qcnt] }

#  This leaves a number of possibilites:
#     
#    1.  One point is within the clipping region and on is outside.  In
#        this case there is always an intersection with ones side of the
#        window,
#
#    2.  Both points are outside the clipping region but not to the
#        same side (both out left or up, etc.)  In this case you can
#        draw a line between them which might intersect two of the window
#        boundaries but which also may not.
#        
#    3.  Both points are outside the clipping region in the same side
#        in which case there is no hope of an intersection with any
#        window edge.

#  Do case 3 first, I believe that we only need to keep track of their 
#  quadrants if they are part of a polygon

   if { (!$left1 && !$left2) || (!$right1 && !$right2) || (!$up1 && !$up2) \
           || (!$down1 && !$down2) } {
      set Qcnt [GPHclipOut Q $Qcnt B $R1(0) $R1(1) ]
      set Qcnt [GPHclipOut Q $Qcnt B $R1(2) $R1(3) ]
      set right1 $right2
      set down1  $down2
      set up1    $up2
      set left1  $left2
      return [list -1 $Qcnt]
   }

# AND finally case 1 and 2.
#   At this point at least one point must lie outside the clipping boundary 
#   and one within.
#
#   The first check is for the case of vertical lines (the x coordinates are 
#   the same.  We need only check the y values since if the x values were out 
#   then we would not have got this far.

   set dR [expr $R1(0) - $R1(2)]
   if { $dR == 0.0 } {
      if { !$up1 } {
         set R2(1) $B(3)
         set ClipOn 1
      } elseif { !$down1 } {
         set R2(1) $B(1)
         set ClipOn 1
      }

      if { !$up2 } {
         set R2(3) $B(3)
         incr ClipOn 2
      } elseif { !$down2 } {
         set R2(3) $B(1)
         incr ClipOn 2
      }

      set right1 $right2
      set down1  $down2
      set up1    $up2
      set left1  $left2
      return [list $ClipOn $Qcnt]
   } 

   set dR [expr $R1(1) - $R1(3)]
   if { $dR == 0.0 } {
      if { !$right1 } {
         set R2(0) $B(2)
         set ClipOn 1
      } elseif { !$left1 } {
         set R2(0) $B(0)
         set ClipOn 1
      }

      if { !$right2 } {
         set R2(2) $B(2)
         incr ClipOn 2
      } elseif { !$left2 } {
         set R2(2) $B(0)
         incr ClipOn 2
      }

      set right1 $right2
      set down1  $down2
      set up1    $up2
      set left1  $left2
      return [list $ClipOn $Qcnt]
   } 

#   We have a diagonal line which exceeds the plot boundaries so first find 
#   linear equation for line
#
#   find slope and intercept of line
#

   set A [expr ($R1(3) - $R1(1)) / ($R1(2) - $R1(0))]
   set C [expr $R1(3) - $A * $R1(2) ]

#   do we have to make any correction to the first set of       */
#   points                                                      */
#

   set ReT ""
   if { !$right1 } {
      set ReT [ GPHclipFxx $B(2) $B(1) $B(3) $A $C ]
   } elseif { !$left1 } {
      set ReT [ GPHclipFxx $B(0) $B(1) $B(3) $A $C ]
   } elseif { !$up1 } {
       lappend ReT [expr ($B(3) - $C ) / $A ]
       lappend ReT $B(3)
   } elseif { !$down1 } {
       lappend ReT [expr ($B(1) - $C ) / $A ]
       lappend ReT $B(1)
   }

# CHECK to make sure we found a solution

   if { [llength $ReT] == 2 } {
      set X [lindex $ReT 0 ]
      set Y [lindex $ReT 1 ]
      if { ($X < $B(0)) || ($X > $B(2)) || ($Y < $B(1)) || ($Y > $B(3)) } {
         set Qcnt [GPHclipOut Q $Qcnt B $R1(0) $R1(1) ]
         set Qcnt [GPHclipOut Q $Qcnt B $R1(2) $R1(3) ]
         set right1 $right2
         set down1  $down2
         set up1    $up2
         set left1  $left2
         return [list -1 $Qcnt]
      } else {
         set R2(0) [lindex $ReT 0 ]
         set R2(1) [lindex $ReT 1 ]
         set ClipOn 1
      }
   } else {
      set R2(0) $R1(0);
      set R2(1) $R1(1);
   }

#
#   do we have to make any correction to the second set of
#   points
#

   set ReT ""
   if { !$right2 } {
      set ReT [ GPHclipFxx $B(2) $B(1) $B(3) $A $C ]
   } elseif { !$left2 } {
      set ReT [ GPHclipFxx $B(0) $B(1) $B(3) $A $C ]
   } elseif { !$up2 } {
       lappend ReT [expr ($B(3) - $C ) / $A ]
       lappend ReT $B(3)
   } elseif { !$down2 } {
       lappend ReT [expr ($B(1) - $C ) / $A ]
       lappend ReT $B(1)
   }

   if { [llength $ReT] == 2 } {
      set R2(2) [lindex $ReT 0 ]
      set R2(3) [lindex $ReT 1 ]
      incr ClipOn 2
   } else {
      set R2(2) $R1(2);
      set R2(3) $R1(3);
   }

   if { $ClipOn == 1 } {
      set Qcnt [GPHclipOut Q $Qcnt B $R1(0) $R1(1) ]
   } elseif { $ClipOn == 2 } {
      set Qcnt [GPHclipOut Q $Qcnt B $R1(2) $R1(3) ]
   }

   set right1 $right2
   set down1  $down2
   set up1    $up2
   set left1  $left2

   return [list $ClipOn $Qcnt]
} 
