#!/bin/sh
# the next line restarts using wish \
exec tclsh $0 $@

if [catch { open [lindex $argv 0] r } fi ] {
   puts stderr "UNABLE TO OPEN [lindex $argv 0]"
}
if [catch { open [lindex $argv 1] w } fo ] {
   puts stderr "UNABLE TO OPEN [lindex $argv 1]"
}

set P1 {[ ]*}
set P2 {([^ ]*)[ ]*}

gets $fi Vi 
puts $fo $Vi
gets $fi Vi
puts $fo $Vi

set I 0
while { [gets $fi Line] >= 0 } {
  regexp "$P1$P2$P2$P2$P2" $Line M P R($I) G($I) B($I)
  incr I
}

set I 0
for { set J 254 } { $J >= 0 } { incr J -2 ; incr I } {
   puts $fo [format "%7d %7d %7d %7d" $I $R($J) $G($J) $B($J) ]
}
for { set J 1 } { $J < 256 } { incr I; incr J 2 } {
   puts $fo [format "%7d %7d %7d %7d" $I $R($J) $G($J) $B($J) ]
}

close $fi
close $fo
