package provide TclGPH 1.0

proc VtkLoadColors { cFile } {
   global colorLUT GphInfo DevCt

   if [catch {open $cFile r} input ] { 
      puts stderr "UNABLE TO OPEN COLOR FILE $cFile"
      return 0
   }

   gets $input LiNe
   set nE [scan $LiNe "%d %s" nC cType]
   if { $nE == 1 } { set cType INTEGER }

   gets $input LiNe
   set nfC [scan $LiNe "%d %d %d %d %d %d %d %d" \
               GphInfo(White) GphInfo(Red) GphInfo(Yellow) GphInfo(Green) \
               GphInfo(Cyan) GphInfo(Blue) GphInfo(Purple) GphInfo(Black) ]

   set nC 0
   if [string match HEX $cType] {
      while { [gets $input LiNe] >= 0 } {
         set nE [scan  $LiNe "%d %s %s %s" Pos($nC) R G B] 
	 set Red($nC) [expr 0x[lindex $LiNe 1]]
	 set Green($nC) [expr 0x[lindex $LiNe 1]]
	 set Blue($nC) [expr 0x[lindex $LiNe 1]]
	 incr nC
      }
   } else {
      while { [gets $input LiNe] >= 0 } {
         set nE [scan  $LiNe "%d %d %d %d" Pos($nC) \
	                        Red($nC) Green($nC) Blue($nC)]
         incr nC
      } 
   }

   close $input

   set GphInfo(nColors) $nColors
   vtkLookupTable colorLUT
      colorLUT SetNumberOfColors $nColors
      for { set I 0 } { $I < $nColors } { incr I } {
         set Red($I) [expr $Red($I) / 255.0]
         set Green($I) [expr $Green($I) / 255.0]
         set Blue($I) [expr $Blue($I) / 255.0]
         eval colorLUT SetTableValue $Pos($I) $Red($I) $Green($I) $Blue($I) 1.0
	 set DevCt($I) [list $Red($I) $Green($I) $Blue($I)]
      } 
}
