package provide TclGPH 1.0

proc VtkFormColor { iC RGB { ChK 1 } } {
   global DevCt GphInfo

   upvar $RGB oC

# GET the color components from the input color.  The input color is
#   either an index into the lookup table or an RGB specification in
#   hex as #RRGGBB

   if [string match "#" [string index $iC 0]] {
      scan $iC "#%2x%2x%2x" R G B
      set oC(0) [expr $R / 255.0]
      set oC(1) [expr $G / 255.0]
      set oC(2) [expr $B / 255.0]
   } else {
     set oC(0) [lindex $DevCt($iC) 0]
     set oC(1) [lindex $DevCt($iC) 1]
     set oC(2) [lindex $DevCt($iC) 2]
   }

   if { $ChK && $GphInfo(revBC) } {
      set R [expr int($oC(0) * 255.0)]
      set G [expr int($oC(1) * 255.0)]
      set B [expr int($oC(2) * 255.0)]
      set C [format "%03d%03d%03d" $R $G $B]
      if [string match $C $GphInfo(sysBC)] {
         set R [expr $R ^ 255]
	 set G [expr $G ^ 255]
	 set B [expr $B ^ 255]
         set oC(0) [expr $R / 255.0]
         set oC(1) [expr $G / 255.0]
         set oC(2) [expr $B / 255.0]
      }
   }
}
