package provide TclGPH 1.0

proc TkSymBol { Just SyM } {
   global WinInfo GphInfo XYZ DevCt DevInfo 

# SET up the screen designation and get plot canvas

   if ![file exists $SyM] {
      set P [lsearch -exact $GphInfo(SyM) $SyM]
      if { $P < 0 } {
         set bFile @[lindex $GphInfo(BmPs) 0] 
      } else { set bFile @[lindex $GphInfo(BmPs) $P] }
   } else { set bFile @$SyM }
    
   set sC Scr$GphInfo(CurScr)
   set sCr $DevInfo($sC).drw
   set wN $GphInfo(curWin)

   if { $WinInfo($wN,Clip) > 0 } {
      if { [GPHlineClip 0] == 0 } { return }
      set X $XYZ(0)
      set Y $XYZ(1)
   } else {
      set X [expr $XYZ(0) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set Y [expr $XYZ(1) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   }

   switch -exact -- $Just {
      right   { set J w }
      center  { set J center }
      left    { set J e }
      default { set J $Just }
   }

   if { [string first "#" $GphInfo(tColor)] >= 0 } {
      set tColor $GphInfo(tColor)
   } else { set tColor  $DevCt($GphInfo(tColor)) }

   if $GphInfo(revBC) {
      if [string match $tColor $GphInfo(sysBC)] {
         scan $tColor "#%02x%02x%02x" R G B
         set R [expr $R ^ 255]
         set G [expr $G ^ 255]
         set B [expr $B ^ 255]
         set tColor [format "#%02x%02x%02x" $R $G $B]
      }
   }

   set Fmt "-bitmap {$bFile} -anchor $J -foreground $tColor"
   if { [string length $GphInfo(tag)] != 0 } {
      append Fmt " -tag [lindex $GphInfo(tag) 0]"
      if { [llength $GphInfo(tag)] > 1 } { set GphInfo(tag) "" }
   }

   eval {$sCr create bitmap} $X $Y $Fmt 
}
