package provide TclGPH 1.0

proc TkLine { } {
   global WinInfo GphInfo XYZ XYZp XYZn DevCt DevInfo 

# SET up the screen designation and get plot canvas

   set sC Scr$GphInfo(CurScr)
   set sCr $DevInfo($sC).drw
   set wN $GphInfo(curWin)
   set sX $wN,s0
   set sY $wN,s1
   set iX $wN,i0
   set iY $wN,i1

   if { $XYZn < 2 } { return }

   if { [string first "#" $GphInfo(lColor)] >= 0 } {
      set lColor $GphInfo(lColor)
   } else { set lColor  $DevCt($GphInfo(lColor)) }

   if $GphInfo(revBC) {
      if [string match $lColor $GphInfo(sysBC)] {
         scan $lColor "#%02x%02x%02x" R G B
         set R [expr $R ^ 255]
         set G [expr $G ^ 255]
         set B [expr $B ^ 255]
         set lColor [format "#%02x%02x%02x" $R $G $B]
      }
   }

   set Fmt "-fill $lColor -capstyle projecting"

# SET up the linestyle

   switch -exact -- $GphInfo(lStyle) {
      SOLID      { }
      DASH1      { append Fmt " -dash ." }
      DASH2      { append Fmt " -dash ," }
      DASH3      { append Fmt " -dash -" }
      DASH4      { append Fmt " -dash _" }
      SPDASH1    { append Fmt " -dash {. }" }
      SPDASH2    { append Fmt " -dash {, }" }
      SPDASH3    { append Fmt " -dash {- }" }
      SPDASH4    { append Fmt " -dash {_ }" }
      DASHDOT1   { append Fmt " -dash ,." }
      DASHDOT2   { append Fmt " -dash -." }
      DASHDOT3   { append Fmt " -dash _." }
      DASH2DOT1  { append Fmt " -dash ,.." }
      DASH2DOT2  { append Fmt " -dash -.." }
      DASH2DOT3  { append Fmt " -dash _.." }
      DASHSPDOT1 { append Fmt " -dash {, . }" }
      DASHSPDOT2 { append Fmt " -dash {- . }" }
      DASHSPDOT3 { append Fmt " -dash {_ . }" }
      default    { append Fmt " -dash $GphInfo(lStyle)" }
   }

   if { [string length $GphInfo(aEnDs)] != 0 } {
      append Fmt " -arrow $GphInfo(aEnDs)"
   }
   if { [string length $GphInfo(aRRow)] != 0 } {
      append Fmt " -arrowshape $GphInfo(aRRow)"
   }

   if { [string length $GphInfo(lWidth)] != 0 } {
      append Fmt " -width $GphInfo(lWidth)"
   }
   if { [string length $GphInfo(tag)] != 0 } {
      append Fmt " -tag [lindex $GphInfo(tag) 0]"
      if { [llength $GphInfo(tag)] > 1 } { set GphInfo(tag) "" }
   }

   if { $WinInfo($wN,Dimen) == 3 } {
      set J 3
      set K 4
      set dI 3
   } else {
      set J 2
      set K 3
      set dI 2
   }

   set LiNe ""

   if { $WinInfo($wN,Clip) > 0 } {
       GPHlineClip 0
       set X [expr floor($XYZ(0) + .5)] 
       set Y [expr floor($XYZ(1) + .5)]
       lappend LiNe $X $Y

       for { set I 1 } { $I < $XYZn } { incr I ; incr J $dI ; incr K $dI} {
          if { $XYZp($I) == 0 } {
             if { [llength $LiNe] > 3 } {
                 eval {$sCr create line} $LiNe $Fmt
             } 
             set LiNe ""
          }
          set X [expr floor($XYZ($J) + .5)] 
          set Y [expr floor($XYZ($K) + .5)]
          lappend LiNe $X $Y
          if { [llength $LiNe] > 3 } {
             eval {$sCr create line} $LiNe $Fmt
             set LiNe [list $X $Y]
          } 
       }
   } else {
       set X [expr floor($XYZ(0) * $WinInfo($sX) + $WinInfo($iX) + .5)] 
       set Y [expr floor($XYZ(1) * $WinInfo($sY) + $WinInfo($iY) + .5)] 
       lappend LiNe $X $Y

       for { set I 1 } { $I < $XYZn } { incr I ; incr J $dI ; incr K $dI} {
          if { $XYZp($I) == 0 } {
             if { [llength $LiNe] > 3 } {
                   eval {$sCr create line} $LiNe $Fmt
             } 
             set LiNe ""
          }
          set X [expr floor($XYZ($J) * $WinInfo($sX) + $WinInfo($iX) + .5)] 
          set Y [expr floor($XYZ($K) * $WinInfo($sY) + $WinInfo($iY) + .5)] 
          lappend LiNe $X $Y

          if { [llength $LiNe] > 3 } {
             eval {$sCr create line} $LiNe $Fmt
             set LiNe [list $X $Y]
          } 
       }
    }
   if { [llength $LiNe] > 3 } { eval {$sCr create line} $LiNe $Fmt }
}
