# RESETS a graphics windows base characteristics based on the current 
#   canvas parameters.  Used when a window is used in multiple canvas's
#   This routine assumes that the window has been previously defined


package provide TclGPH 1.0

proc GPHwinReset { wN } {
   global WinInfo GphInfo

   set GphInfo(curWin) $wN

   GPHwinScale $wN Xp Yp Zp 3

   if { $WinInfo($wN,pa0) == 1 } {
      set V [expr log10($WinInfo($wN,pp0)) ]
      set X1 [expr $V * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set V [expr log10($WinInfo($wN,pp3)) ]
      set X2 [expr $V * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
   } else {
      set X1 [expr $WinInfo($wN,pp0) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set X2 [expr $WinInfo($wN,pp3) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
   }

#
#  Get the pixel locations of the Y corners of the window
#

   if { $WinInfo($wN,pa1) == 1 } {
      set V [expr log10($WinInfo($wN,pp1)) ]
      set Y1 [expr $V * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
      set V [expr log10($WinInfo($wN,pp4)) ]
      set Y2 [expr $V * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   } else {
      set Y1 [expr $WinInfo($wN,pp1) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
      set Y2 [expr $WinInfo($wN,pp4) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   }

   if { $Y1 > $Y2 } {
      set TmP $Y1
      set Y1 $Y2
      set Y2 $TmP
   }

   set X1 [expr floor($X1 + .5)]  
   set Y1 [expr floor($Y1 + .5)]
   set X2 [expr floor($X2 + .5)]  
   set Y2 [expr floor($Y2 + .5)]

   set WinInfo($wN,b) [list $X1 $Y1 $X2 $Y2]
   switch -exact -- $WinInfo($wN,px) {
      X   {  set WinInfo($wN,pp0) 0
             set WinInfo($wN,pp3) [expr $X2 - $X1]
             GPHwinScale $wN Xp Yp Zp 0
          }
      Y   {  set WinInfo($wN,pp1) 0
             set WinInfo($wN,pp4) [expr $Y2 - $Y1]
             GPHwinScale $wN Xp Yp Zp 0
          }
      XY  {  set WinInfo($wN,pp0) 0
             set WinInfo($wN,pp3) [expr $X2 - $X1]
             set WinInfo($wN,pp1) 0
             set WinInfo($wN,pp4) [expr $Y2 - $Y1]
             GPHwinScale $wN Xp Yp Zp 0
          }
   }
}
