package provide TclGPH 1.0

proc GPHsetCanvas { Canvas X Y Xs Ys } {
   global Prefs 

   set pAr $Canvas
   set sCr $pAr.drw

   if { ($X == $Xs) && ($Y == $Ys) } {
      eval { canvas $sCr -highlightthickness 0 -borderwidth 0 \
              -height $Y -width $X -background black }
      grid $sCr -sticky news
   } elseif { $X == $Xs } {
      eval {canvas $sCr \
        -yscrollcommand [list $pAr.yscroll set] \
        -highlightthickness 0 -borderwidth 0 \
        -height $Y -width $X -background black \
        -scrollregion "0 0 $Xs $Ys" }
      scrollbar $pAr.yscroll -orient vertical -command [list $sCr yview]
      grid $sCr $pAr.yscroll -sticky news
      grid rowconfigure $pAr 0 -weight 1
      grid columnconfigure $pAr 0 -weight 1
   } elseif { $Y == $Ys } {
      eval {canvas $sCr \
        -xscrollcommand [list $pAr.xscroll set] \
        -highlightthickness 0 -borderwidth 0 \
        -height $Y -width $X -background black \
        -scrollregion "0 0 $Xs $Ys" }
      scrollbar $pAr.xscroll -orient horizontal -command [list $sCr xview]
      grid $sCr -sticky news
      grid $pAr.xscroll -sticky ew
      grid rowconfigure $pAr 0 -weight 1
      grid columnconfigure $pAr 0 -weight 1
   } else {
      eval {canvas $sCr \
        -xscrollcommand [list $pAr.xscroll set] \
        -yscrollcommand [list $pAr.yscroll set] \
        -highlightthickness 0 -borderwidth 0 \
        -height $Y -width $X -background black \
        -scrollregion "0 0 $Xs $Ys" }
      scrollbar $pAr.xscroll -orient horizontal -command [list $sCr xview]
      scrollbar $pAr.yscroll -orient vertical -command [list $sCr yview]
      grid $sCr $pAr.yscroll -sticky news
      grid $pAr.xscroll -sticky ew
      grid rowconfigure $pAr 0 -weight 1
      grid columnconfigure $pAr 0 -weight 1
   }

   $sCr config -cursor crosshair
} 
