package provide TclGPH 1.0

proc GPHrealLen { Len Beg Action} {
   global WinInfo GphInfo

   set wN $GphInfo(curWin)
   set cLen ""
   set Z 0.0
   
   switch -exact -- $Action {
      PIXEL {
         if { $WinInfo($wN,a0) == 1 } { 
            set X [expr log10(($Beg + $Len) / $Beg) * WinInfo($wN,s0)]
         } else { set X [expr $Len * $WinInfo($wN,s0)] } 

         if { $WinInfo($wN,a1) == 1 } { 
            set Y [expr log10(($Beg + $Len) / $Beg) * WinInfo($wN,s1)]
         } else { set Y [expr $Len * $WinInfo($wN,s1)] }
         if { $Y < 0.0 } { set Y [expr -1.0 * $Y ] }

      }
      SCALED {
         if { $WinInfo($wN,a0) == 1 } { 
            set Lx [expr exp(log($Beg + $Len / $Beg))]
         } else { set Lx $Len }

         if { $WinInfo($wN,a1) == 1 } { 
            set Ly [expr exp(log($Beg + $Len / $Beg))]
         } else { set Ly $Len }

         if { $WinInfo($wN,Dimen) == 3 } {
            if { $WinInfo($wN,a2) == 1 } { 
               set Lz [expr exp(log($Beg + $Len / $Beg))]
            } else { set Lz $Len }
            set Z [expr $Lz/$WinInfo($wN,s2)] 
         }

         set X [expr $Lx/$WinInfo($wN,s0)] 
         set Y [expr $Ly/$WinInfo($wN,s1)] 
         if { $Y < 0.0 } { set Y [expr -1.0 * $Y ] }
         if { $Z < 0.0 } { set Z [expr -1.0 * $Z ] }
      }
   }

   set X [expr abs($X)]
   set Y [expr abs($Y)]
   set Z [expr abs($Z)]
   return [list $X $Y $Z]
}
