package provide TclGPH 1.0

proc GPHmapXY { iD nP Lng Lat Xx Yy Status FmT Ops { Post OFF } } {
   global RtoD PI GphInfo WinInfo

   if { [string compare CARTESIAN $iD] == 0 } { return $nP }
   if [string match OFF $Post] { set pP 0 } else { set pP 1 }

   upvar $Lng P
   upvar $Lat T
   upvar $Xx X
   upvar $Yy Y
   upvar $Status S

   set oPlist [list LNGOFFSET LATOFFSET RADIUS]
   set LeN [llength $Ops]
   for { set I 0 } { $I < $LeN } { incr I } {
      set oP([lindex $oPlist $I]) [lindex $Ops $I] 
   }

   set I 0
   set K 0
   if { $FmT == 1 } { 
      set J 1
      set wN $GphInfo(curWin)
      set InC $WinInfo($wN,Dimen)
   } else { 
      set J 0
      set InC 1
      for { set N 0 } { $N < $nP } { incr N } { set S($N) 1 }
   }

   switch -exact -- $iD {
      LAMBERT_CYLINDRICAL { 
         set iD CYLINDRICAL_EQUAL_AREA
         set oP(LATOFFSET) 0.0
      }
      BEHRMANN_CYLINDRICAL { 
         set iD CYLINDRICAL_EQUAL_AREA
         set oP(LATOFFSET) 30.0
      }
      TRISTAN_EDWARDS { 
         set iD CYLINDRICAL_EQUAL_AREA
         set oP(LATOFFSET) 37.383
      }
      PETERS { 
         set iD CYLINDRICAL_EQUAL_AREA
         set oP(LATOFFSET) 44.138
      }
      GALL_ORTHOGRAPHIC { 
         set iD CYLINDRICAL_EQUAL_AREA
         set oP(LATOFFSET) 45.0
      }
      BALTHASART { 
         set iD CYLINDRICAL_EQUAL_AREA
         set oP(LATOFFSET) 50.0
      }
      EQUIRECTANGULAR { 
         set iD CYLINDRICAL_EQUIDISTANT
         set oP(LATOFFSET) 0.0
      }
      MILLER37 { 
         set iD CYLINDRICAL_EQUIDISTANT
         set oP(LATOFFSET) 37.5
      }
      MILLER43 { 
         set iD CYLINDRICAL_EQUIDISTANT
         set oP(LATOFFSET) 43.0
      }
      MILLER50 { 
         set iD CYLINDRICAL_EQUIDISTANT
         set oP(LATOFFSET) 50.4666666
      }
   }

   switch -exact -- $iD {
      CYLINDRICAL {
         set pP 0
         set P0 $oP(LNGOFFSET)
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
             set X($I) [expr $P($I) - $P0] 
             set Y($J) [expr tan($T($J) / $RtoD)] 
         } 
      }
      CYLINDRICAL_EQUAL_AREA {
         set pP 0
         set P0 $oP(LNGOFFSET)
         set T0 $oP(LATOFFSET)
         set CkT [expr cos($T0 / $RtoD)] 
         set SkT [expr 1.0/cos($T0 / $RtoD)] 
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
             set X($I) [expr ($P($I) - $P0) * $CkT] 
             set Y($J) [expr $SkT * sin($T($J) / $RtoD)] 
         } 
      }
      CYLINDRICAL_EQUIDISTANT {
         set pP 0
         set P0 $oP(LNGOFFSET)
         set T0 $oP(LATOFFSET)
         set CkT [expr cos($T0 / $RtoD)] 
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
            set X($I) [expr ($P($I) - $P0) * $CkT] 
            set Y($J) $T($J) 
         } 
      }
      ECKERT_SINUSOIDAL {
         set pP 0
         set P0 $oP(LNGOFFSET)
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
            set X($I) [expr ($P($I) - $P0) * (cos($T($J)/$RtoD) + 1.0) / 2.0] 
            set Y($J) $T($J)
         } 
      }
      ECKERT_ELLIPSOIDAL {
         set pP 0
         set P0 $oP(LNGOFFSET)
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
            set NormTSq [expr $T($J) * $T($J) /8100.0 ]
            set X($I) [expr ($P($I) - $P0) * (1.0 - $NormTSq) / 2.0] 
            set Y($J) $T($J)
         } 
      }
      MERCATOR {
         set pP 0
         set P0 $oP(LNGOFFSET)
         set QPI [expr $PI / 4]
         set AC  [expr $RtoD * 2.0]
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
            set X($I) [expr $P($I) - $P0] 
            if { $T($J) <= -90.0 } {
               set T($J) -89.0
            } elseif { $T($J) >= 90.0 } { set T($J) 89.0 }
            set Y($J) [expr log(tan($QPI + $T($J) / $AC))]
         } 
      }
      MOLLWEIDE {
         set pP 0
         set P0 $oP(LNGOFFSET)
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
            set NormTSq [ expr $T($J) * $T($J) /8100.0 ]
            set X($I) [ expr ($P($I) - $P0) * sqrt(1.0 - $NormTSq) ]
            set Y($J) $T($J)
         } 
      }
      ORTHOGRAPHIC {
         set P0 $oP(LNGOFFSET)
         set T0 $oP(LATOFFSET)
         set sTo [expr sin($T0 / $RtoD) ]
         set cTo [expr cos($T0 / $RtoD) ]
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
            set Pa [expr ($P($I) - $P0) / $RtoD]
            set Ta [expr $T($J) / $RtoD]
            set cP [expr cos($Pa)]
            set cT [expr cos($Ta)]
            set sT [expr sin($Ta)]
            set X($I) [ expr $cT * sin($Pa)]
            set Y($J) [ expr $cTo * $sT - $sTo * $cT * $cP]
            set ChK [ expr $sTo * $sT + $cTo * $cT * $cP]
            if { $ChK < 0 } { set S($K) -1 } 
         } 
      }
      POLAR {
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
	     set tX [expr $T($I) * cos($P($J) /$RtoD)] 
             set tY [expr $T($I) * sin($P($J) /$RtoD)] 
	     set X($I) $tX
             set Y($J) $tY
         } 
      }
      SINUSOIDAL {
         set pP 0
         set P0 $oP(LNGOFFSET)
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
             set X($I) [expr ($P($I) - $P0) * cos($T($J) / $RtoD)] 
             set Y($J) $T($J)
         } 
      }
      STEREOGRAPHIC {
         set P0 $oP(LNGOFFSET)
         set T0 $oP(LATOFFSET)
         set R  $oP(RADIUS)
         set SkT [expr sin($T0 / $RtoD)] 
         set CkT [expr cos($T0 / $RtoD)] 
         for { } { $K < $nP } { incr I $InC ; incr J $InC ; incr K } {
            set CP [expr cos( ($P($I) - $P0) / $RtoD)] 
            set SP [expr sin( ($P($I) - $P0) / $RtoD)] 
            set CT [expr cos($T($J) / $RtoD)] 
            set ST [expr sin($T($J) / $RtoD)] 
            set dN [expr (1. + $SkT * $ST + $CkT * $CT * $CP)]
            if { $dN != 0.0 } {
               set tR [expr 2. * $R / $dN]
               set S($K) 1
            } else { 
               set tR [expr 2. * $R / 1.0e-10]
               set S($K) -1
            }
            set X($I) [expr $tR * $CT * $SP] 
            set Y($J) [expr $tR * ($CkT * $ST - $SkT * $CT * $CP)] 
         } 
      }
   }

   if $pP {
      set NoMv 1
      if { $FmT == 1 } {
         set P1 0 ; set P2 0
         for { set K 0 ; set I 0 } { $K < $nP } { incr K } {
            if { $S($K) >= 0 } {
               if $NoMv { set S($P1) 0 } else { set S($P1) $S($K) }
               set NoMv 0
               incr P1
               set X($P2) $X($I) ; incr P2 ; incr I
               set X($P2) $X($I) ; incr P2 ; incr I
            } else { incr I 2 ; set NoMv 1 }
         }
      } else {
         set P1 0 
         for { set K 0 } { $K < $nP } { incr K } {
            if { $S($K) >= 0 } {
               if $NoMv { set S($P1) 0 } else { set S($P1) $S($K) }
               set NoMv 0
               incr P1
               set X($P1) $X($K)
               set Y($P1) $Y($K)
            }  else { set NoMv 1 }
         }
      }

      set nP $P1 
   }

   return $nP
}
