# Res - Arc resolution in degrees.  If positive then this resolution will be
#       used in drawing the arc.  If negative then the lesser of this resolution
#       or the arc length divided by 10 will be used.

package provide TclGPH 1.0

proc Arc { wN X Y Z R BegA EndA MkSq MkPie Res { Tag "" } } {
   global WinInfo GphInfo RtoD DevInfo 

   set twN $wN
   if { ($MkSq == "X") || ($MkSq == "Y") } {
      set sW bW$GphInfo(CurScr)
      set aC(0) $X ; set aC(1) $Y
      GPHretCoor $wN aC aOuT SCREEN
      GPHretCoor $sW aOuT aRc WINDOW

      set aR(0) [expr $X + $R]
      set aR(1) [expr $Y + $R]
      GPHretCoor $wN aR aOuTr SCREEN
      GPHretCoor $sW aOuTr aRcr WINDOW

      if { $MkSq == "X" } {
         set R [expr $aRc(0) - $aRcr(0)]
      } else { set R [expr $aRc(1) - $aRcr(1)] }

      set wN $sW
      set X $aRc(0)
      set Y $aRc(1)
   }

   set GphInfo(curWin) $wN
   if { [string length $Tag] > 0 } { set GphInfo(tag) [list $Tag E] }
   set tR $GphInfo(ToRad)

   if { $BegA > $EndA } { set EndA [ expr $EndA + 360.0 ] }
   if { ![string match OFF $GphInfo(fColor)] } { 
      set EndIt -2 
   } else { set EndIt 2 }

   set BegR [expr $BegA * $GphInfo(ToRad)]
   set EndR [expr $EndA * $GphInfo(ToRad)]

   set TotAng [expr $EndA - $BegA];
   if { $TotAng == 360.0 } { set Cyrkle 1 } else { set Cyrkle 0 }

   set sC Scr$GphInfo(CurScr)
   if { $MkSq == "X" } {
      set rX $R
      if { $DevInfo($sC.SqX) == 1.0 } {
         set rY [ expr $R * $DevInfo($sC.SqY)]
      } else { set rY [expr $R / $DevInfo($sC.SqX)] }
   } elseif { $MkSq == "Y" } {
      set rY $R
      if { $DevInfo($sC.SqY) == 1.0 } {
         set rX [ expr $R * $DevInfo($sC.SqX)]
      } else { set rX [expr $R / $DevInfo($sC.SqY)] }
   } else { set rX $R ; set rY $R }

   set Xa [expr $X + $rX * cos($BegR) ]
   set Ya [expr $Y + $rY * sin($BegR) ]
   if { $Cyrkle == 0 } {
      if { ![string match OFF $GphInfo(fColor) ] || $MkPie } {
         GPHlineData $X $Y 0.0 0 0
         GPHlineData $Xa $Ya 0.0 1 0
      }
   } else { GPHlineData $Xa $Ya 0.0 0 0 }

   if { $Res > 0.0 } {
       set dA [expr $Res / $RtoD]
   } else { 
       set Res [expr -$Res]
       set dA  [expr $TotAng / 10.0 ]
       if { $dA < $Res } {
          set dA [expr $dA / $RtoD]
       } else { set dA [expr $Res / $RtoD] }
   }

   set A [expr $BegR + $dA]
   while { $A < $EndR } { 
      set Xa [expr $X + $rX * cos($A) ]
      set Ya [expr $Y + $rY * sin($A) ]
      GPHlineData $Xa $Ya 0.0 1 0
      set A [expr $A + $dA]
   }

   set A $EndR
   set Xa [expr $X + $rX * cos($A) ]
   set Ya [expr $Y + $rY * sin($A) ]
   GPHlineData $Xa $Ya 0.0 1 0


   if { $Cyrkle == 0 } {
      if { ![string match OFF $GphInfo(fColor) ] || $MkPie } {
         GPHlineData $X $Y 0.0 1 0
      }
   } else { 
      set Xa [expr $X + $rX * cos($BegR) ]
      set Ya [expr $Y + $rY * sin($BegR) ]
      GPHlineData $Xa $Ya 0.0 1 0 
   }
   GPHlineData $Xa $Ya 0.0 1 $EndIt 

   set GphInfo(curWin) $twN
}
