package provide GMEPlot 1.0

# THIS is the interface which allows you to create scatter plots

proc XYGui { tW } {
   global gmANS GphInfo env

# LAY out the window names for the GUI frame structure
                                                                                
   set W  .xy
   set Wa .xy.ctrl
   set Wb .xy.opts
   set Wc .xy.parm

# IF no menu needed then leave.  Destroy any menu which may already
#  exist.  ONLY do this if we got her via the toggle button!

   if {[string length $tW] > 0 } {
      GUIoptsToggle $tW gmANS(XYplot) PRI
      if [string match NO $gmANS(XYplot)] {
         if [winfo exists $W] { destroy $W }
         return
      }
   }

   set ScOps [list LINEAR|0 LOG|1]
   set AxiS  [list X Y]
                                                                           
   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "DEFINE XY SCATTER PLOTS"
                                                                                
      GUIFrame $Wa -1 pack|top||x
      GUIFrame $Wc -1 pack|top||x

      set C #FF0000
      set FonT [list fixed 12 bold]

      GUILabel $Wa.mlab "PLOT DEFINITIONS" center pack|left 0 0 "" $FonT
      GUIbuttonPush $Wa.close Close pack|right "wm iconify $W" 6
      
      set Row 0
      GUIblankRow $Wc $Row 1.0
      incr Row
      GUILabel $Wc.plab "PLOT"     center grid|$Row|0|ew 0 0 $C
      GUILabel $Wc.qlab "QUANTITY" center grid|$Row|1|ew 0 0 $C
      GUILabel $Wc.mnlab "MINIMUM" center grid|$Row|2|ew 0 0 $C
      GUILabel $Wc.mxlab "MAXIMUM" center grid|$Row|3|ew 0 0 $C
      GUILabel $Wc.sclab "SCALE"   center grid|$Row|4|ew 0 0 $C
      GUILabel $Wc.mnrlab "MIN CUT" center grid|$Row|5|ew 0 0 $C
      GUILabel $Wc.mxrlab "MAX CUT" center grid|$Row|6|ew 0 0 $C
      incr Row

      for { set I 0 } { $I < $gmANS(nLP) } { incr I } { 
         for { set J 0 } { $J < 2 } { incr J } { 
            set iD $I$J
            set LaB "$I [lindex $AxiS $J]"
            GUILabel $Wc.pq${iD}lab $LaB w grid|$Row|0|w 

            GUIbuttonMenu $Wc.q${iD} "" grid|$Row|1|ew $gmANS(SsOps)  \
                "GUIoptsProcess $Wc.q${iD} gmANS(S${iD}) ALT " 6 -1 "" left
            set LaB [GUIoptsInfo $Wc.q$iD OPTV $gmANS(S${iD}) ALT PRI]
            $Wc.q${iD} configure -text $LaB
            GUIboxEntry $Wc.p${iD}min  grid|$Row|2|ew 9 gmANS(S${iD}Min)
            GUIboxEntry $Wc.p${iD}max  grid|$Row|3|ew 9 gmANS(S${iD}Max)
            GUIbuttonToggle $Wc.p{$iD}sca $gmANS(S${iD}Sca) grid|$Row|4|ew \
                 $ScOps "GUIoptsToggle $Wc.p{$iD}sca gmANS(S${iD}Sca) PRI " 6
            GUIboxEntry $Wc.p${iD}rmin  grid|$Row|5|ew 9 gmANS(S${iD}MinR)
            GUIboxEntry $Wc.p${iD}rmax  grid|$Row|6|ew 9 gmANS(S${iD}MaxR)
            incr Row
	    if [expr $J % 2] {
              GUIblankRow $Wc $Row 1.0
              incr Row
	    }    
         }
      }
   }

   update
}
