package provide GMEPlot 1.0

# THIS procedure sets up the windows for the lineplots

proc SetUpLinePlots {  } {
   global gmANS GphInfo WinInfo DevInfo

# THIS is the character size 

   set cSx [lindex $gmANS(LPcS) 0] 
   set cSy [lindex $gmANS(LPcS) 1]

# GET the last window opened up for the 2D plots and set the current
#   window number to the next

   set wN [expr [lindex $gmANS(pNs) end] + 1]

# THE X extent of the plots is constant so set that now leaving a 7 character
#    space on both sides.  That should be enough 

   set xB [expr 7.0 * $cSx]
   set xT [expr 1.0 - 7.0 * $cSx]

# THE Y base of the top plot and the total are we have for the plots.
#   There is a gap between the plots which is set at 2.0 characters.
#   dY is the length for one plot and dYS is the length of the separation.

   set yBase [expr 1.0 - 7.0 * $cSy]
   set yLen  [expr 1.0 - (12.0 + 2.5 * ($gmANS(TotalLP) - 1)) * $cSy]
   set dY    [expr $yLen / $gmANS(TotalLP)]
   set dYS   [expr 2.5 * $cSy]

# LOOP over the plots and establish a window for each one

   set gmANS(lpNs) ""
   set xMx [expr abs($gmANS(pMax))]
   set pN 0
   for { set I 0 } { $I < $gmANS(nLP) } { incr I } {
      if { $gmANS(LP${I}Q) > 0 } {
         set yT [expr $yBase - $pN * ($dY + $dYS) ] 
         set yB [expr $yT - $dY]
         set WinInfo($wN,corFmt) 1
         if { $gmANS(Q${I}0) > 0 } {
            set yMn $gmANS(P${I}0Min)
            set yMx $gmANS(P${I}0Max)
            set ySc $gmANS(P${I}0Sca)
         } else {
            set yMn $gmANS(P${I}1Min)
            set yMx $gmANS(P${I}1Max)
            set ySc $gmANS(P${I}1Sca)
         }

         RelWindow $wN B $xB $yB 0. $xT $yT 0. 1.0 $yMn 0. $xMx $yMx 0.
         SetAxis $wN PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD HOLD $ySc HOLD
         SetAxis $wN SECONDARY HOLD HOLD HOLD HOLD HOLD HOLD HOLD $ySc HOLD

         if { $gmANS(LP${I}Q) == 2 } {
            set yMn $gmANS(P${I}1Min)
            set yMx $gmANS(P${I}1Max)
            set ySc $gmANS(P${I}1Sca)
            SetAxis $wN SECONDARY HOLD $yMn HOLD HOLD $yMx HOLD HOLD $ySc HOLD
         } 

         DefinePlot $wN $wN
         lappend gmANS(lpNs) $wN
         set gmANS(pN${wN}eC) 0
         incr wN
         incr pN
      }
   }
}
