package provide GMEPlot 1.0

# THIS procedure sets up the windows for the 2D plots.

proc SetUp2DPlots { } {
   global gmANS GphInfo WinInfo DevInfo

# THIS is the character size 

   set cSx [lindex $gmANS(2DcS) 0] 
   set cSy [lindex $gmANS(2DcS) 1]

# THIS is the number of 2D plots we need to output
                                                                                
   set nR  $gmANS(nR)
   set nC  $gmANS(nC)
   set gmANS(AnnPlot) [expr ($nR - 1) * $nC ]
   set gmANS(tPlots) [expr $nR * $nC]

# Get the base X and Y positions of the plots

   set xBase [expr 5.0 * $cSx]
   set yBase [expr 1.0 - 2.0 * $cSy]
   set xLen [expr ($gmANS(xUpper) - 7.0 * $cSx) / double($nC)]
   set yLen [expr (1.0 - $gmANS(yLower) - 7.0 * $cSy) / double($nR)]

# PLOTS are square - make sure they will be here

   if { $xLen > $yLen } { set dS $yLen } else { set dS $xLen }

# LOOP over all the plots and set up the window in which each will be
#   output.

   set xMaX [expr $xBase  + $nC * $dS]
   set yMiN [expr $yBase  - $nR * $dS - 5.0 * $cSy]
   set wN 0
   set gmANS(pNs) ""
   for { set I 0 } { $I < $nR } { incr I } {
      set yT [expr $yBase - $I * $dS] 
      set yB [expr $yT - $dS]
      for { set J 0 } { $J < $nC } { incr J } {
         set xB [expr $xBase  + $J * $dS]
         set xT [expr $xB + $dS]
         set WinInfo($wN,corFmt) 1
         RelWindow $wN A $xB $yB 0.0 $xT $yT 0.0 $gmANS(pMin) \
                       $gmANS(pMin) 0.0 $gmANS(pMax) $gmANS(pMax) 0.0
         lappend gmANS(pNs) $wN
         incr wN
      }
   }

   return [list $xMaX $yMiN]
}
