package provide GMEPlot 1.0

# THIS gets and plots any SSIES data along the DMSP orbit track

proc SSIESOrbTrackPlot { } {
   global gmANS env ExDa WinInfo

   set pI [PlotCheck 80 93]
   set nP [llength $pI]
   if { $nP == 0 } { return }

   GridParams pgI 2D
   set EnD [expr $pgI(4) - 1]
   set peC $gmANS(cerr)
   TUgridInfo 32 pgI xC

   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pI $I] "|"]
      set wN  [lindex $tP 0]
      set yA  [lindex $tP 1]
      set Q   [lindex $tP 2]
      set pID [lindex $tP 3]
      set eV 0.0
      if [string match Yb $yA] { 
         set pC $gmANS(clh) 
         if { $WinInfo($wN,pa1) == 1 } { set eC "<=" } else { set eC NONE }
      } else { 
         set pC $gmANS(crh)
         if { $WinInfo($wN,sa1) == 1 } { set eC "<=" } else { set eC NONE }
      }

      set pL [list $pC $eC $eV]
      set qL [list $peC $eC $eV HOLD 6 +]
      set MinR $gmANS(P${pID}MinR)
      set MaxR $gmANS(P${pID}MaxR)

      switch -exact -- $Q {
         80 { OrbitTrackData SSIES Ni mD qD $MinR $MaxR   }
         81 { OrbitTrackData SSIES Te mD qD $MinR $MaxR   }
         82 - 
         84 { OrbitTrackData SSIES Ti mD qD $MinR $MaxR   }
         83 { OrbitTrackData SSIES vY mD qD $MinR $MaxR   }
         86 { OrbitTrackData SSIES vZ mD qD $MinR $MaxR   }
         85 - 
         87 { OrbitTrackData SSIES vX mD qD $MinR $MaxR   }
         88 { OrbitTrackData SSIES TeCp mD qD $MinR $MaxR }
         89 { OrbitTrackData SSIES TiCp mD qD $MinR $MaxR }
         90 { OrbitTrackData SSIES H mD qD $MinR $MaxR   }
         91 { OrbitTrackData SSIES He mD qD $MinR $MaxR  }
         92 { OrbitTrackData SSIES O mD qD $MinR $MaxR   }
         93 { OrbitTrackData SSIES HF mD qD $MinR $MaxR   }
      }
      Plot2D $wN Xb $yA xC mD 0 $EnD LINE $pL
      Plot2D $wN Xb $yA xC qD 0 $EnD SCATTER $qL

      switch -exact -- $Q {
         84 {
            set pL [list $gmANS(cex$gmANS(pN${wN}eC)) $eC $eV]
            OrbitTrackData SSIES Te mD qD $MinR $MaxR
            Plot2D $wN Xb $yA xC mD 0 $EnD LINE $pL
            Plot2D $wN Xb $yA xC qD 0 $EnD SCATTER $qL
            lappend gmANS(Q84) $gmANS(cex$gmANS(pN${wN}eC))
            incr gmANS(pN${wN}eC)
         }
         87 {
            set pL [list $gmANS(cex$gmANS(pN${wN}eC)) $eC $eV]
            OrbitTrackData SSIES vY mD qD $MinR $MaxR
            Plot2D $wN Xb $yA xC mD 0 $EnD LINE $pL
            Plot2D $wN Xb $yA xC qD 0 $EnD SCATTER $qL
            lappend gmANS(Q87) $gmANS(cex$gmANS(pN${wN}eC))
            incr gmANS(pN${wN}eC)

            set pL [list $gmANS(cex$gmANS(pN${wN}eC)) $eC $eV]
            OrbitTrackData SSIES vZ mD qD $MinR $MaxR
            Plot2D $wN Xb $yA xC mD 0 $EnD LINE $pL
            Plot2D $wN Xb $yA xC qD 0 $EnD SCATTER $qL
            lappend gmANS(Q87) $gmANS(cex$gmANS(pN${wN}eC))
            incr gmANS(pN${wN}eC)
	 }
      }
   }
   update
}
