package provide GMEPlot 1.0

# THIS plots the Rato along the orbit track

proc RaOrbTrackPlot { } {
   global gmANS env RtoD RgI

# SEE if we need to put up a cut through an Ratio Plot

   set pI [PlotCheck 100 102]
   set nP [llength $pI]
   if { $nP == 0 } { return }
   set nE $gmANS(nOrbit)

   GridParams gI 2D 
   TUgridInfo 32 gI xC
   set EnD [expr $gI(4) - 1] 
   set tG [expr $RgI(4) * $RgI(5)]

   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pI $I] "|"]
      set wN [lindex $tP 0]
      set yA [lindex $tP 1]
      set Q  [lindex $tP 2]
      if [string match Yb $yA] {
         set pC $gmANS(clh)
      } else { set pC $gmANS(crh) }

      switch -exact -- $Q {
         100 { set iD H }
         101 { set iD M }
         102 { set iD F }
      }

      set MinR $gmANS(ionLow)
      InOutList TOARRAY GriD gmANS(rG$iD) $tG
      OrbitTrackData CUT RATIO GriD V $MinR 0.0 XY RgI
      if [string match Yb $yA] {
         set pC $gmANS(clh)
      } else { set pC $gmANS(crh) }
      Plot2D $wN Xb $yA xC V 0 $EnD LINE [list $pC < 1.0e-9]
   }
   update
}
