package provide GMEPlot 1.0

proc RCMapMom { Energy dFunc RnG } {
   global gmANS GphInfo PI

   upvar $Energy eV
   upvar $dFunc  dF

   set MinD 1.0e-4

   set ReT [FormXY eV dF oX oY mAV hAV]
   set nP [lindex $ReT 0]
   set nM [lindex $ReT 1]
   set nH [lindex $ReT 2]

   if [ string match FULL $RnG] {
      if [ string match WIDTHS $gmANS(momTYPE)] {
         set nE 0
         set Len [llength mAV]
         for { set I 0 } { $I < $Len } { incr I } {
            set J  [lindex $mAV $I]
            set bE($nE) [lindex $gmANS(MbE) $I]
            set eE($nE) [lindex $gmANS(MeE) $I]
            set fDF($nE) $oY($nE)
            incr nE
         }
         set Len [llength hAV]
         for { set I 0 } { $I < $Len } { incr I } {
            set J  [lindex $hAV $I]
            set bE($nE) [lindex $gmANS(HbE) $J]
            set eE($nE) [lindex $gmANS(HeE) $J]
            set fDF($nE) $oY($nE)
            incr nE
         }
         Moments2D fDF bE eE $nP 1.67e-24 WIDTHS $MinD ReTF
      } else {
         for { set I 0 } { $I < $nP } { incr I } {
            set bC($I) [expr $oX($I) * 1000.0]
            set fDF($I) $oY($I)
         }
         Moments2D fDF bC bC $nP 1.67e-24 CENTERS $MinD ReTF
      }
   } else {
      if [ string match WIDTHS $gmANS(momTYPE)] {
         set nE 0
         for { set I 0 } { $I < $nM } { incr I } {
            set J  [lindex $mAV $I]
            set mbE($I) [lindex $gmANS(MbE) $J]
            set meE($I) [lindex $gmANS(MeE) $J]
            set mDF($I) $oY($nE)
            incr nE
         }
         for { set I 0 } { $I < $nH } { incr I } {
            set J  [lindex $gmANS(AVAILHENA) $I]
            set hbE($I) [lindex $gmANS(HbE) $J]
            set heE($I) [lindex $gmANS(HeE) $J]
            set hDF($I) $oY($nE)
            incr nE
         }
         Moments2D mDF mbE meE $nM 1.67e-24 WIDTHS $MinD ReTM
         Moments2D hDF hbE heE $nH 1.67e-24 WIDTHS $MinD ReTH
      } else {
         set nE 0
         for { set I 0 } { $I < $nM } { incr I } {
            set mbC($I) [expr $oX($nE) * 1000.0]
            set mDF($I) $oY($nE)
            incr nE
         }
         for { set I 0 } { $I < $nH } { incr I } {
            set hbC($I) [expr $oX($nE) * 1000.0]
            set hDF($I) $oY($nE)
            incr nE
         }
         Moments2D mDF mbC mbC $nM 1.67e-24 CENTERS $MinD ReTM
         Moments2D hDF hbC hbC $nH 1.67e-24 CENTERS $MinD ReTH
      }
   }

   set MoMs ""
   if [ string match FULL $RnG] {
      set ReTF(TmP) [expr $ReTF(TmP) / 1000.0]
      set MoMs [list $ReTF(Den) $ReTF(TmP)]
   } else {
      set ReTM(TmP) [expr $ReTM(TmP) / 1000.0]
      set ReTH(TmP) [expr $ReTH(TmP) / 1000.0]
      set MoMs [list $ReTM(Den) $ReTM(TmP) $ReTH(Den) $ReTH(TmP)]
   }
}
