package provide GMEPlot 1.0

# THIS gets and plots the electron precipitation along the DMSP orbit track

proc ParOrbTrackPlot { Species } {
   global gmANS env ExDa gLS

   if [string match ELECTRON $Species] {
      set piDa 20 ; set piDb 29
   } else { set piDa 10 ; set piDb 19 }

   set pI [PlotCheck $piDa $piDb]
   set nP [llength $pI]
   if { $nP == 0 } { return }

   set sN [string range $gmANS(DMSPsat) 6 7]
   if [string match ELECTRON $Species] {
      set KeY [GetDataKey DMSP $gmANS(DMSPsat) SSJ4 SSJ4 ${sN}SE] 
   } else {
      set KeY [GetDataKey DMSP $gmANS(DMSPsat) SSJ4 SSJ4 ${sN}SI] 
   }

   GridParams gL ETIME
   GridParams pgI 2D

# USE this version and structure number

   set Ver 0
   set N 0

# OPEN the data and position to the starting time

   FileOpen $KeY $Ver \
       $gmANS(sY) $gmANS(sD) $gmANS(sH) $gmANS(sM) $gmANS(sS) \
       $gmANS(fY) $gmANS(fD) $gmANS(fH) $gmANS(fM) $gmANS(fS)

   FilePos $KeY $Ver $gmANS(sY) $gmANS(sD) $gmANS(sH) \
       $gmANS(sM) $gmANS(sS) FINE

# GET the UNIT Algorithms - units are erg/cm^2-s
#
# High Energy Range (p and e): Sensor 0, Unit 12
# Low Energy Range (p and e):  Sensor 1, Unit 12

   set U12h [UTILunits $KeY,$Ver 12 0]
   set U12l [UTILunits $KeY,$Ver 12 1]

# GET the data

   set More -1
   set nE 0
   while { $More < 0 } {
      set EoF [ReadUDF $KeY $Ver $N 0 0 0 0]
      ConvertToUnits $KeY $Ver $N $U12h HiS SENSOR
      set EoF [ReadUDF $KeY $Ver $N 1 0 1 0]
      ConvertToUnits $KeY $Ver $N $U12l LowS SENSOR

      set yB $ExDa($N,BYR)
      set dB $ExDa($N,BDY)
      set mB $ExDa($N,BMSEC)
      set yE $ExDa($N,EYR)
      set dE $ExDa($N,EDY)
      set mE $ExDa($N,EMSEC)

      if { $nE == 0 } {
         set dT [expr ($mE - $mB)/1000]
	 if { $dT < 0 } { set dT [expr $dT +  86400] }
	 set MdT [expr $dT / 2.0]
      }

      set curT [list $yB $dB $mB 0]
      if [string match EOF $EoF] { break }
                                                                                
      set Tm [expr [TUtimeConv $gmANS(baseT) $curT 0 gmANS(Base)] + $MdT]

      TUgridInfo 0 gL rV $Tm 0.0
      set P $rV(0)

# SUM excludes the highest and lowest energy - runs from 45 eV to 21 keV

      if { ($Tm >= $gmANS(sP)) && ($Tm <= $gmANS(eP)) && ($P >= 0) } {
         set tF $LowS(0)
         for { set I 1 } { $I < 9 } { incr I } { 
            set tF [expr $tF + $HiS($I) + $LowS($I)] 
         }
            
         set pX($nE) $gLS($P)
         set pY($nE) $tF
         incr nE
      }
      set More [TUtimeCmp 0 $yE $dE $mE $gmANS(fY) $gmANS(fD) $gmANS(fMs)]
   }

   set tY(0) 0.0
   set EnD [expr $pgI(4) - 1] 

   TUdataGrid $nE 1 pX pX $nE tY tY pY gN gNorM pgI
   TUgridFill1D gN pgI X HM -1 0 gNorM
   TUgridInfo 32 pgI xC
   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pI $I] "|"]
      set wN [lindex $tP 0]
      set yA [lindex $tP 1]
      set Q  [lindex $tP 2]
      if [string match Yb $yA] { 
         set pC $gmANS(clh) 
      } else { set pC $gmANS(crh) }
      switch -exact -- $Q {
         10 -
         20 { 
            Plot2D $wN Xb $yA xC gN 0 $EnD LINE [list $pC < 1.0e-5]
         }
      }
   }
   update
}
