package provide GMEPlot 1.0

proc IonInvRead { File xX yY vV AnC {ExP 0} {xB xX} {yB yY} \
                                    {Src UA} {Cor XY} } {
   global RtoD PI

   upvar $xX  X
   upvar $yY  Y
   upvar $vV  D
   upvar $AnC A
   if { $ExP == 1 } {
      upvar $xB Xt
      upvar $yB Yt
   }

   if [catch {open $File r} fd] {
      puts stderr "UNABLE TO OPEN ION INV FILE: $File"
      return [list 0 0 0]
   }
   set nP 0

   if [string match UA $Src] {

#  FIRST line is the time field, next two are header info

      gets $fd TimE 
      gets $fd Line 
      gets $fd keV 
      gets $fd Line 

      scan $TimE "%e %e %e %e %e" Yr Dy Hr Mn Sc 
      set A(YR) [expr int($Yr)]
      set A(DY) [expr int($Dy)]
      set A(HR) [expr int($Hr)]
      set A(MN) [expr int($Mn)]
      set A(SC) [expr int($Sc)]
      scan $keV "%s %f" TmP A(KeV)

#  READ in the data

      while { [gets $fd Line] > 0 } {
         scan $Line "%e %e %e" X($nP) Y($nP) D($nP) 
         incr nP
      }

      if [string match UAOLD $Src]  { 
         set Fac [expr $PI * 4.0 * 8.0]
         for { set I 0 } { $I < $nP } { incr I } {
            set D($I) [expr $D($I) / $Fac]
         }
      }

      set nX [expr int(sqrt($nP))]
      set nY $nX
      set dX [expr abs($X(0) - $X($nX)) / 2.0]
      set dY [expr abs($Y(0) - $Y(1)) / 2.0]

      switch  -exact -- $Cor {
         PT {
            if { $ExP == 1 } {
               set dR [expr sqrt ($dX * $dX + $dY * $dY)]

               for { set I 0 } { $I < $nP } { incr I } {
                  set R [expr sqrt($X($I) * $X($I) + $Y($I) * $Y($I))]
                  set P [expr atan2 ($Y($I), $X($I))]
                  set Y($I) [expr $R - $dR]
                  set Yt($I) [expr $R + $dR]
                  set dP [expr atan2 ($dY , $R)]
                  set X($I) [expr $P - $dP]
                  set Xt($I) [expr $P + $dP]
               }      
            } else {
               for { set I 0 } { $I < $nP } { incr I } {
                  set Vx $X($I)
                  set Vy $Y($I)
                  set X($I) [expr atan2($Vy, $Vx)]
                  set Y($I) [expr sqrt($Vx * $Vx + $Vy * $Vy)]
               }
            }
         }
         XY {
            if { $ExP == 1 } {
               for { set I 0 } { $I < $nP } { incr I } {
                  set R $X($I)
                  set P $Y($I)
                  set X($I) [expr $R - $dX]
                  set Xt($I) [expr $R + $dX]
                  set Y($I) [expr $P - $dY]
                  set Yt($I) [expr $P + $dY]
               }      
            } 
         }
      }
   } else {

# SKIP the two header lines

      for { set I 0 } { $I < 2 } { incr I } { gets $fd Line }

# READ in the PHI, L values, and Goodness of Inversion

      gets $fd PhI
      gets $fd LShell
      gets $fd GoI
      set PhI [string trim $PhI]
      set LShell [string trim $LShell]

# READ in the Phi angles (0 degrees is noon).  Add the closing angle.  Each
#   angle is the beginning angle in the phi range.

      set nX 0 
      while { [string length $PhI] > 0 } {
         regexp "(\[^ \]*)\[ \]*(.*)" $PhI M Phase($nX) PhI
         incr nX
      }

# READ the L-Shells.  Again add the closing L-shell.  Each L-Shell is the
#   start of the L-Shell bin.

      set nY 0 
      while { [string length $LShell] > 0 } {
         regexp "(\[^ \]*)\[ \]*(.*)" $LShell M Ls($nY) LShell
         incr nY
      }

# SET up the upper/lower/mid arrays for Phase and Ls

      if $ExP {
         set dP [expr abs($Phase(0) - $Phase(1))]
         for { set I 0 } { $I < $nX } { incr I } {
            if { $Phase($I) < 180.0 } {
               set PhL($I) [expr $Phase($I) / $RtoD]
               set PhU($I) [expr ($Phase($I) + $dP) / $RtoD]
            } else {
               set PhL($I) [expr ($Phase($I) - 360.0) / $RtoD]
               set PhU($I) [expr ($Phase($I) + $dP - 360.0) / $RtoD]
            }
         }
         set dL [expr abs($Ls(0) - $Ls(1))]
         for { set I 0 } { $I < $nY } { incr I } {
            set LsL($I) [expr $Ls($I)]
            set LsU($I) [expr $Ls($I) + $dL]
         }
      } else { 
         set dP [expr abs($Phase(0) - $Phase(1))/2.0]
         for { set I 0 } { $I < $nX } { incr I } {
            set Ph [expr $Phase($I) + $dP]
            if { $Ph < 180.0 } {
               set PhL($I) [expr $Ph / $RtoD]
            } else { set PhL($I) [expr $Ph - 360.0) / $RtoD] }
         }
         set dL [expr abs($Ls(0) - $Ls(1))/2.0]
         for { set I 0 } { $I < $nY } { incr I } {
            set LsL($I) [expr $Ls($I) + $dL]
         }
      }

      for { set I 0 } { $I < $nY } { incr I } { 
         gets $fd LiNe
         set LiNe [string trim $LiNe]
         set J 0
         while { [string length $LiNe] > 0 } {
            set X($nP) $PhL($J)
            set Y($nP) $LsL($I)
            if $ExP {
               set Xt($nP) $PhU($J)
               set Yt($nP) $LsU($I)
            } 
            regexp "(\[^ \]*)\[ \]*(.*)" $LiNe M D($nP) LiNe
            incr J
            incr nP
         }
      }
   } 

   close $fd
   return [list $nX $nY $nP]
}
