package provide GMEPlot 1.0

# THIS gets the DMSP orbit track if there is a DMSP overlay

proc HeOrbTrackPlot { } {
   global gmANS env RtoD HeImG HegI

# SEE if we need to put up a cut through an EUV inversion plot

   set pI [PlotCheck 1 1]
   set nP [llength $pI]
   if { $nP == 0 } { return } 

   GridParams gI 2D 
   TUgridInfo 32 gI xC
   OrbitTrackData CUT He HeImG V 0.0 0.0 $gmANS(HeFORMAT) HegI
   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pI $I] "|"] 
      set wN [lindex $tP 0]
      set yA [lindex $tP 1]
      set Q  [lindex $tP 2]
      if [string match Yb $yA] { 
         set pC $gmANS(clh) 
      } else { set pC $gmANS(crh) }
      Plot2D $wN Xb $yA xC V 0 [expr $gI(4) - 1] LINE [list $pC < 0.5]
   }
   update
}
