package provide GMEPlot 1.0

# THIS procedure starts up the graphics and does the initial window 
#    assignments.  It also puts up the colorbar since all of the info
#    is available at this time

proc GraphicsUp { } {
   global gmANS GphInfo WinInfo DevInfo

# THIS is percentage of the window in either X or Y which is dedicated
#   to the colorbar.

   if [string match YES $gmANS(DmSp)] {
      set cBp 0.25;
   } else { set cBp .15 } 

# THIS is the space which we have to work with on the screen.  Determine
#   the maximum and minimum length.

   set X [winfo screenwidth .]
   set Y [winfo screenheight .]

   set X 900
   set Y 650

# THIS is the screen area we get to work within

   set GphInfo(xScrL) [expr int($X * $gmANS(Zoom))]
   set GphInfo(yScrL) [expr int($Y * $gmANS(Zoom))]

# SOME initial presets. mP is the percentage of the plot length occupied
#   by the 2D maps.  The colorbar is HORIZONTAL for line plots to the left
#   of the 2D mapx and VERTICAL for line plots under the 2D maps.  If
#   only 2D maps then its according to the users selection.

   if [string match YES $gmANS(DmSp)] {
      set mP $gmANS(PlotBrk)
      if [string match BOTTOM $gmANS(pLoc)] {
         set pID  0
         set gmANS(cbDir) VERTICAL
      } else {
         set pID  1
         if [string match VERTICAL $gmANS(cbDir)] {
            set $gmANS(cbDir) RHORIZONTAL
         }
      }
   } else {
      set mP 1.0
      if [string match VERTICAL $gmANS(cbDir)] {
         set pID  0
      } else { set pID  1 }
   }

# THE length of the screen occupied by a single plot.

   if { $gmANS(nR) > $gmANS(nC) } {
      set sP [expr $gmANS(PlotBrk) / double($gmANS(nR))]
   } else { set sP [expr $gmANS(PlotBrk) / double($gmANS(nC))] }

# START figuring out what goes where.  The illustration below gives
#   some of the variable definitions.  B should be 0 for 2D only plots. 
#
#             BOTTOM                            RIGHT
#            VARIABLES                        VARIABLES
#
#
#               C      D                        A      B
#          ...............                 ................
#          .         .   .                 .        .     .
#          .         .   .                 .        .     .
#        A .       T .   .               C .        .     .
#          .         .   .                 .    T   .     . 
#          ...............                 ..........     .
#          .             .                 .        .     .
#        B .             .               D .        .     .
#          ...............                 ................
#                MiN                           
#
# NOTE: In above T is the total length available for the map plots 
#    while A and C are the length that they actually require

   if { $GphInfo(yScrL) > $GphInfo(xScrL) } {
      set D  [expr int($cBp * $mP * $GphInfo(xScrL))]
   } else { set D  [expr int($cBp * $mP * $GphInfo(yScrL))] }

   if !$pID { 
      set T  [expr int($mP * $GphInfo(yScrL))]
      set tL [expr $GphInfo(xScrL) - $D]
      set sL [expr int($T / double($gmANS(nR)))] 
      set gL [expr $sL * $gmANS(nC)] 
      if { $gL > $tL } { set sL [expr int($tL / double($gmANS(nC)))] }

     set A [expr $sL * $gmANS(nR)]
     set B [expr $GphInfo(yScrL) - $A]
     set C [expr $sL * $gmANS(nC)]

      set GphInfo(xScrL) [expr int($C + $D)]
      set mP [expr 1.0 - double($A) / double($GphInfo(yScrL))]
      set xP [expr double($C) / double($GphInfo(xScrL))]
      set AxL 0.0  ;  set BxL 0.0
      set AxU $xP  ;  set BxU 1.0
      set AyL $mP  ;  set ByL 0.0
      set AyU 1.0  ;  set ByU $mP
      if { $gmANS(nCB) > 2 } {
          set yT [expr (1.0 + $mP) / 2.0]
          set CxL $xP ; set CxU 1.0 ; set CyL $yT ; set CyU 1.0
          set DxL $xP ; set DxU 1.0 ; set DyL $mP ; set DyU $yT
      } else { set CxL $xP ; set CxU 1.0 ; set CyL $mP ; set CyU 1.0 }
   } else { 
      set T  [expr int($mP * $GphInfo(xScrL))]
      set tL [expr $GphInfo(yScrL) - $D]
      set sL [expr int($T / double($gmANS(nC)))] 
      set gL [expr $sL * $gmANS(nR)] 
      if { $gL > $tL } { set sL [expr int($tL / double($gmANS(nR)))] }

      set A [expr $sL * $gmANS(nC)]
      set B [expr $GphInfo(xScrL) - $A]
      set C [expr $sL * $gmANS(nR)]

      if [string match NO $gmANS(DmSp)] { set GphInfo(xScrL) [expr int($A)] }

      set mP [expr double($A) / double($GphInfo(xScrL))]
      set yP [expr 1.0 - double($C) / double($GphInfo(yScrL))]
      set yL [expr 1.0 - (double($C + $D)) / double($GphInfo(yScrL))]
      set AyL $yP  ;  set ByL 0.0
      set AyU 1.0  ;  set ByU 1.0
      set AxL 0.0  ;  set BxL $mP
      set AxU $mP  ;  set BxU 1.0
      if { $gmANS(nCB) > 2 } {
          set xT [expr $mP / 2.0]
          set CxL $xT ; set CxU $mP ; set CyL $yL ; set CyU $yP
          set DxL 0.0 ; set DxU $xT ; set DyL $yL ; set DyU $yP
      } else { set CxL 0.0 ; set CxU $mP ; set CyL $yL ; set CyU $yP }
   }

# FIRE up the graphics

   GraphicsOn TK $gmANS(CtBl) $gmANS(ScrBgnd) 
   bind $DevInfo(Scr$GphInfo(CurScr)).drw <Button-1> {SelectPoint %W %x %y}
   bind $DevInfo(Scr$GphInfo(CurScr)).drw <Button-3> {DeSelectPoint %W %x %y}

# SET up colors to use in line plots.  Red and Cyan are the colors used
#    for plots against the left and righthand axis respectively.  The
#    rest of the colors are extras used when there are more than two
#    plots in a graph.

     set gmANS(clh)  $GphInfo(Red)
     set gmANS(crh)  $GphInfo(Blue)
     set gmANS(cex0) $GphInfo(Green)
     set gmANS(cex1) $GphInfo(Purple)
     set gmANS(cex2) $GphInfo(Cyan)
     set gmANS(cex3) $GphInfo(White)
     set gmANS(cex4) [expr int(($GphInfo(Yellow) + $GphInfo(Green))/2)]
     set gmANS(cex5) [expr int(($GphInfo(Green) + $GphInfo(Cyan))/2)]
     set gmANS(cex6) [expr int(($GphInfo(Cyan) + $GphInfo(Blue))/2)]
     set gmANS(cex7) [expr int(($GphInfo(Blue) + $GphInfo(Purple))/2)]
     set gmANS(cerr) $GphInfo(Cyan)

# SET up the three base windows.  Window A contains the 2D plots, window B
#    contains the lineplots, and Window C and maybe D holds the colorbar(s).

   if { $gmANS(nR) > $gmANS(nC) } {
      set pX [expr double($gmANS(nC)) / double($gmANS(nR))]
      set pY 0.0
   } else { 
      set pX 1.0
      set pY [expr 1.0 - double($gmANS(nR)) / double($gmANS(nC))]
   } 

   set gmANS(yLower) $pY
   set gmANS(xUpper) $pX

   GenWindow A $AxL $AyL 0.0 $AxU $AyU 0.0 0.0 $pY 0.0 $pX 1.0 0.0

   if { $gmANS(Zoom) >= .9 } { set tS 12 } else { set tS 10 }
   TextProp $tS
   set gmANS(2DcS) [GPHtextLen A XY] 
   set MxMn [SetUp2DPlots] 

   set xMaX [expr ([lindex $MxMn 0] / $pX) * 1.05]
   set yMiN [expr ([lindex $MxMn 1] - $pY) / (1.0 - $pY) * 1.05]

   if !$pID {
      if { $xMaX < 1.0 } {
         set xMaX [expr $xMaX * $AxU]
         set CxU [expr $CxU - ($AxU - $xMaX)]
         set CxL $xMaX
         if { $gmANS(nCB) > 2 } { set DxL $CxL ; set DxU $CxU }
         set BxU $CxU
         if { $yMiN > 0.0 } {
            set yMiN [expr $AyL + $yMiN * ($AyU - $AyL)]
            if { $gmANS(nCB) > 2 } { 
               set dY [expr ($yMiN - $DyL) / 2.0]
               set DyL $yMiN
               set DyU [expr $DyU + $dY]
            } 
            set CyL $yMiN
            set ByU $yMiN
         }
      }
   } else {
      if { $xMaX < 1.0 } {
         set xMaX [expr $xMaX * $AxU]
         if { $gmANS(nCB) > 2 } { 
            set dX [expr ($CxU - $xMaX) / 2.0]
            set DxU [expr $DxU - $dX]
            set CxL $DxU
         } 
         set CxU $xMaX
         set BxL $xMaX
         if { $yMiN > 0.0 } {
            set yMiN [expr $AyL + $yMiN * ($AyU - $AyL)]
            set dY [expr $yMiN - $CyU]
            set CyU $yMiN
            set CyL [expr ($CyL + $dY) / 2.0]
            if { $gmANS(nCB) > 2 } { 
               set DyU $yMiN
               set DyL [expr ($DyL + $dY)/2.0]
            } 
            set ByL $CyL
         }
      }
   }

   if [string match YES $gmANS(DmSp)] {
      GenWindow B $BxL $ByL 0.0 $BxU $ByU 0.0 0.0 0.0 0.0 1.0 1.0 0.0

      if { $gmANS(TotalLP) > 0 } {
         if { $gmANS(Zoom) >= .9 } { set tS 10 } else { set tS 8 }
         TextProp $tS
         set gmANS(LPcS) [GPHtextLen A XY] 
         SetUpLinePlots
      }
   }

   GenWindow C $CxL $CyL 0.0 $CxU $CyU 0.0 0.0 0.0 0.0 1.0 1.0 0.0
   if { $gmANS(nCB) > 2 } {
      GenWindow D $DxL $DyL 0.0 $DxU $DyU 0.0 0.0 0.0 0.0 1.0 1.0 0.0
   }

   TextProp 12
   UpCBar
   update
}
