package provide GMEPlot 1.0

# THIS gets the DMSP orbit track if there is a DMSP overlay

proc GetOrbitTrack { } {
   global gmANS env ExDa oLS oMLT oGLAT gLS gGLAT gMLT oTM

   set iN [lindex $gmANS(ORBIT) 0] 
   set vI [lindex $gmANS(ORBIT) 1] 

# GET the data key for the DMSP orbit data

   if [string match ORBIT $iN] {
      set sN [string range $gmANS(DMSPsat) 5 7]
   } else { set sN [string range $gmANS(DMSPsat) 6 7] }

   set KeY [GetDataKey DMSP $gmANS(DMSPsat) OA $iN ${sN}$vI] 


# USE this version and structure number

   set Ver 0
   set N 0

# OPEN the data and position to the starting time

   FileOpen $KeY $Ver \
       $gmANS(sY) $gmANS(sD) $gmANS(sH) $gmANS(sM) $gmANS(sS) \
       $gmANS(fY) $gmANS(fD) $gmANS(fH) $gmANS(fM) $gmANS(fS)

   FilePos $KeY $Ver $gmANS(sY) $gmANS(sD) $gmANS(sH) \
       $gmANS(sM) $gmANS(sS) FINE

# GET the UNIT Algorithms
#
# L-Shell: s0, u0
# MLT:     s1, u1
# GMLAT:   s2, u2

   set s0 [lindex $gmANS(ORBIT) 2] 
   set u0 [lindex $gmANS(ORBIT) 3] 
   set s1 [lindex $gmANS(ORBIT) 4] 
   set u1 [lindex $gmANS(ORBIT) 5] 
   set s2 [lindex $gmANS(ORBIT) 6] 
   set u2 [lindex $gmANS(ORBIT) 7] 

   set U0 [UTILunits $KeY,$Ver $u0 $s0]
   set U1 [UTILunits $KeY,$Ver $u1 $s1]
   set U2 [UTILunits $KeY,$Ver $u2 $s2]

# GET the data

   set More -1
   set nE 0
   while { $More < 0 } {
      set EoF [ReadUDF $KeY $Ver $N $s0 0 0 0]
      set oLS($nE) [ConvertToUnits $KeY $Ver $N $U0 DaTa SENSOR]
      set EoF [ReadUDF $KeY $Ver $N $s1 0 0 0]
      set oMLT($nE) [ConvertToUnits $KeY $Ver $N $U1 DaTa SENSOR]
      set EoF [ReadUDF $KeY $Ver $N $s2 0 1 0]
      set oGLAT($nE) [ConvertToUnits $KeY $Ver $N $U2 DaTa SENSOR]

      set yB $ExDa($N,BYR)
      set dB $ExDa($N,BDY)
      set mB $ExDa($N,BMSEC)
      set yE $ExDa($N,EYR)
      set dE $ExDa($N,EDY)
      set mE $ExDa($N,EMSEC)
      set curT [list $yB $dB $mB 0]
      if [string match EOF $EoF] { break }

      if { $nE == 0 } { 
	 set dT [expr ($mE - $mB)/1000]
	 if { $dT < 0 } { set dT [expr $dT +  86400] }
	 set MdT [expr $dT / 2.0] 
	 set gmANS(SdT) $dT
      }

      set oTM($nE) [expr [TUtimeConv $gmANS(baseT) $curT 0 gmANS(Base)] + $MdT]

      incr nE
      set More [TUtimeCmp 0 $yE $dE $mE $gmANS(fY) $gmANS(fD) $gmANS(fMs)]
   }

# GET the start and stop array positions corresponding to the user input
#   start and stop times.

   set gmANS(SlS) 0
   for { set I 0 } { $I < $nE } { incr I } {
      set gmANS(ElS) $I 
      if { $oTM($I) < 0 } {
         set gmANS(SlS) $I
      } else { if { $oTM($I) > $gmANS(eP) } { break } }
   }

# GET LS, MLT, ang GLAT in common time based grids

   set tY(0) 0.0
   GridParams gI ETIME

   TUgridInfo 0 gI rV $gmANS(sP) 0.0
   set gmANS(uB) $rV(0)
   TUgridInfo 0 gI rV $gmANS(eP) 0.0
   set gmANS(uE) $rV(0)

   TUdataGrid $nE 1 oTM oTM $nE tY tY oLS gLS gNorM gI
   TUgridFill1D gLS gI X LI -1 0 gNorM
   TUdataGrid $nE 1 oTM oTM $nE tY tY oMLT gMLT gNorM gI
   TUgridFill1D gMLT gI X HM -1 0 gNorM
   TUdataGrid $nE 1 oTM oTM $nE tY tY oGLAT gGLAT gNorM gI
   TUgridFill1D gGLAT gI X HM -1 0 gNorM

   set gmANS(nOrbit) $nE
}
