package provide GMEPlot 1.0

# THIS procedure puts up the colorbar

proc UpCBar { } {
   global gmANS GphInfo WinInfo DevInfo

# COLORBAR location depends on whether its vertical or horizontal.  It has
#   its own window, C.

   if [string match VERTICAL $gmANS(cbDir)] {
      set xcB 0.4 ; set xcT 0.6
      if { $gmANS(nCB) < 3 } {
         set ycB 0.2 ; set ycT 0.8
      } else { set ycB 0.1 ; set ycT 0.9 }
   } else {
      set ycB 0.4 ; set ycT 0.6
      if { $gmANS(nCB) < 3 } {
         set xcB 0.2 ; set xcT 0.8
      } else { set xcB 0.1 ; set xcT 0.9 }
   }

   if { $gmANS(nCB) < 3 } { 
      if { $gmANS(Zoom) >= .9 } { set tS 12 } else { set tS 10 }
   } else { 
      if { $gmANS(Zoom) >= .9 } { set tS 10 } else { set tS 8 }
   }
   PlotColor HOLD HOLD 255

   set On(0) $gmANS(CBarE)
   set On(1) $gmANS(CBarI)
   set On(2) $gmANS(CBarT)
   set On(3) $gmANS(CBarD)
   set On(4) $gmANS(CBarR)

   set Mn(0) $gmANS(cBHMin) ; set Mx(0) $gmANS(cBHMax) 
   set Sc(0) $gmANS(cBHSca) 
   set Mn(1) $gmANS(cBIMin) ; set Mx(1) $gmANS(cBIMax) 
   set Sc(1) $gmANS(cBISca) 
   set Mn(2) $gmANS(cBIDMin) ; set Mx(2) $gmANS(cBIDMax) 
   set Sc(2) $gmANS(cBIDSca) 
   set Mn(3) $gmANS(cBITMin) ; set Mx(3) $gmANS(cBITMax) 
   set Sc(3) $gmANS(cBITSca) 
   set Mn(4) $gmANS(cBIRMin) ; set Mx(4) $gmANS(cBIRMax) 
   set Sc(4) $gmANS(cBIRSca) 

   set VLab [list "He+ Den" "Ion dFE FLUX" "Ion Den" "Ion Temp" Ratio]
   set HLab [list "He+ Den (/cc)" "Ion Flux (#/cm2-s-sr-keV)" \
                  "Ion Den (/cc)" "Ion Temp (keV)" Ratio ]

   set pID [list EUV ION MOMD MOMT RATIO ]
   set cBiD [list a b c d]

   set cInputs(WHITE)     NO
   set cInputs(POS)       RELATIVE
   set cInputs(ANNOTATE)  YES
   set cInputs(AXIS)      YES
   set cInputs(FMT)       $gmANS(cbDir)
   set cInputs(LABELS)    "" 
   set cInputs(PSIZE)     HOLD:HOLD:$tS:$tS
   set cInputs(SSIZE)     HOLD:HOLD:$tS:$tS
   set cInputs(LEV)       0.5:0.5
   set sA p ; set sB PRIMARY ; set sC P ; set sD PRI
   set CB 0 ; set NcB 0
   set C [lindex $cBiD $NcB]
   set cW [list C D E F]

   for { set I 0 } { $I < 5 } { incr I } {
      if $On($I) {
         set gmANS(c[lindex $pID $I])  ${C}$sD
         set cInputs(${sA}MIN)   $Mn($I)
         set cInputs(${sA}MAX)   $Mx($I)
         set cInputs(${sA}SCA)   $Sc($I)
         set cInputs($sB) ON:ON:ON:ON
         if [string match LOG $cInputs(${sA}SCA)] { 
            set cInputs($sB) ON:ON:ON:ON
            set cInputs(${sC}FMTS)   HOLD:HOLD:%.0e
         } else { set cInputs(${sC}FMTS)   HOLD:HOLD:%.1f }
         if [string match VERTICAL $gmANS(cbDir)] {
            append cInputs(LABELS) [lindex $VLab $I]
            if [string match LOG $cInputs(${sA}SCA)] { 
               set cInputs(${sC}FMTS)   HOLD:HOLD:expon
            }
         } else { append cInputs(LABELS) [lindex $HLab $I] }
         if { $sA == "p" } { append cInputs(LABELS) : }
         incr CB
         set sA s ; set sB SECONDARY ; set sC S ; set sD SEC
      }

      if { $CB == 2 } {
         set cBw [lindex $cW $NcB]
         set cB [ColorBar $cBw $xcB $ycB 0.0 $xcT $ycT 0.0 cInputs cP cS]
         set gmANS(${C}PRI) [list $cP(0) $cP(1) $cP(2) $cP(3) $cP(4)]
         set gmANS(${C}SEC) [list $cS(0) $cS(1) $cS(2) $cS(3) $cS(4)]
         set sA p ; set sB PRIMARY ; set sC P ; set sD PRI
         set CB 0 
	 set cInputs(LABELS) ""
         incr NcB
         set C [lindex $cBiD $NcB]
      }
   }
   if { $CB == 1 } {
      set cBw [lindex $cW $NcB]
      set cB [ColorBar $cBw $xcB $ycB 0.0 $xcT $ycT 0.0 cInputs cP cS]
      set gmANS(${C}PRI) [list $cP(0) $cP(1) $cP(2) $cP(3) $cP(4)]
      set gmANS(${C}SEC) [list $cS(0) $cS(1) $cS(2) $cS(3) $cS(4)]
   }
}
