package provide GMEPlot 1.0

# THIS puts up an EUV simulation plot

proc PlotSpectra { eV dF } {
   global env gmANS GphInfo WinInfo

   upvar $eV X
   upvar $dF Y

   set pN $gmANS(curSpN)
   set sN $gmANS(sN)
   
   set sP [ expr (int($sN / 6) * 2) % 8]
   set cP [ expr int($sN % 6)]

   set gmANS(curCP) $cP
   set C  $GphInfo([lindex $gmANS(pCol) $cP])
   set Sm [lindex $gmANS(pSyM) $sP]
   set Sh [lindex $gmANS(pSyM) [expr $sP + 1]]

   set W .sWin$pN
   if { [winfo exists $W] == 0 } {
      toplevel $W

      GUIFrame $W.opts 0 pack|top||both
      GUIFrame $W.info 0 pack|top||both
      GUIFrame $W.sp 0 pack|top||both

      GUIbuttonPush $W.opts.fit "Fit It" pack|right  "SpectraExtra" 6

      for { set I 0 } { $I < 6 } { incr I } { 
         for { set J 0 } { $J < $gmANS(sPCol) } { incr J } { 
            set rc r${I}c$J
            GUIboxEntry $W.info.$rc grid|$I|$J 9 gmANS(sI$rc)
         }
      }

      GUICanvas $W.sp 500 500 500 500
      SetScreen 1 $W.sp

      GenWindow sW0 0. 0. 0. 1.0 1.0 0.0 0. 0. 0. 1. 1. 0.
      PlotColor HOLD $GphInfo(bColor) $GphInfo(bColor)
      Box sW0 $WinInfo(sW0,pp0) $WinInfo(sW0,pp1) 0.0 \
              $WinInfo(sW0,pp3) $WinInfo(sW0,pp4) 0.0
      PlotColor HOLD $GphInfo(lColor) $GphInfo(lColor)

      GenWindow $pN 0.15 0.1 0.0 0.90 0.90 0.0 0.0 1.0e-33 0.0 80.0 1.0e-24 0.
      SetAxis $pN PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD HOLD 1 HOLD
      SetAxis $pN SECONDARY HOLD HOLD HOLD HOLD HOLD HOLD HOLD 1 HOLD
      DefinePlot $pN $pN
   }

   SetScreen 1 $W.sp

   if !$gmANS(UpSp) {
      set xLab "Center Energy"
      set yLab "Phase Space"
      set xTopA "Phase Space Density vs Center Energy"
      set xTopB "   (sec^3/cm^6)           (keV)     "
      set xTa 3.0
      set xTb 1.0
      set xTc 8.0
      set xTd 6.0
      PLTinfoChg $pN ALL NUMBERS NSIZE 12
      PLTinfoChg $pN ALL NUMBERS TSIZE 12
      PLTinfoChg $pN Yb NUMBERS NENDS MIN
      PLTinfoChg $pN ALL NUMBERS TCOLOR 255
      PLTinfoChg $pN X  NUMBERS NFORMAT %.1f
      PLTinfoChg $pN Y  NUMBERS NFORMAT expon
      PLTinfoChg $pN Yt  NUMBERS NPOSITION INSIDE
      PLTinfoChg $pN Y  TICKS MJNUMBER 5
      PLTinfoChg $pN X  TICKS MJNUMBER 5
      PLTinfoChg $pN X  TICKS MNNUMBER 5

      set nOps [list BOT BOT BOTH BOTH]
      set aOps [list $xLab 1 $yLab 2 "" 1]

      PlotOutlines $pN $aOps $nOps

      set gmANS(UpSp) 1
      set cS [GPHtextLen M XY]
      set gmANS(spCsX) [lindex $cS 0]
      set gmANS(spCsY) [lindex $cS 1]
   }

   set GphInfo(tag) XY$sN

   set mOpts [list $C NONE 0.0 SyM 10 $Sm]
   set hOpts [list $C NONE 0.0 SyM 10 $Sh]
   if { ($gmANS(MHomits) == 1) || ($gmANS(MHomits) == 3) } {
       set ReT [FormXY X Y oX oY mAV hAV]
       set mE [expr [lindex $ReT 1] - 1]
       set hB [lindex $ReT 1]
       set hE [expr [lindex $ReT 0] - 1]
       Plot2D $pN Xb Yb oX oY 0 $mE SCATTER $mOpts
       Plot2D $pN Xb Yb oX oY $hB $hE SCATTER $hOpts
   } else {
       set mEnD [expr [llength $gmANS(AVAILMENA)] -1]
       if { $mEnD >= 0 } {
          Plot2D $pN Xb Yb X Y 0 $mEnD SCATTER $mOpts
          set hBeG [llength $gmANS(AVAILMENA)]
       } else { set hBeG 0 }
       set hEnD [expr $hBeG + [llength $gmANS(AVAILHENA)] - 1]
       Plot2D $pN Xb Yb X Y $hBeG $hEnD SCATTER $hOpts
   }
   set GphInfo(tag) ""

   set P [lsearch -exact $gmANS(sPS) OPEN ]
   if { $P >= 0 } {
      set gmANS(sPS) [lreplace $gmANS(sPS) $P $P XY$sN]
      set gmANS(curC) $P
      set C [lindex $gmANS(gCol) $gmANS(curCP)]
      $W.info.r0c$P delete 0 end
      $W.info.r0c$P insert end [format "%6.2f X" $gmANS(sX)]
      $W.info.r0c$P configure -fg $C
      $W.info.r1c$P delete 0 end
      $W.info.r1c$P insert end [format "%6.2f Y" $gmANS(sY)]
      $W.info.r1c$P configure -fg $C
   } else { set gmANS(curC) -1 }

   update
   SetScreen 0 NONE
}
