package provide GMEPlot 1.0

# THIS gets the DMSP orbit track if there is a DMSP overlay

proc PlotOrbitTrack { } {
   global gmANS env RtoD GphInfo oLS oMLT

   set nP [llength $gmANS(pNs)] 
   TextProp 8 HOLD HOLD
   
   for { set I 0 } { $I < $nP } { incr I } {
      set wN [lindex $gmANS(pNs) $I]
      WinClip $wN 1
      set TwN $GphInfo(curWin)
      set GphInfo(curWin) $wN
      set hC [expr [GPHtextLen "+" X] / 2.0]
      set hC2 [expr $hC * $hC]
      set GphInfo(curWin) $TwN

      set OK 0

      for { set J 0 } { $J < $gmANS(nOrbit) } { incr J } {
         set R $oLS($J)
         if { ($R >= 1.0) && ($R <= 6.0) } {
            set A [expr 360.0 * ($oMLT($J) - 12.0) / 24.0 / $RtoD]
            if !$OK { 
               set OK 1
               PlotColor HOLD $GphInfo(White) $GphInfo(White)
               set xO [expr $R * cos($A)]
               set yO [expr $R * sin($A)]
               set xL [expr $xO - $hC]
               set yL [expr $yO - $hC]
               set xU [expr $xO + $hC]
               set yU [expr $yO + $hC]
               Box $wN $xL $yL 0.0 $xU $yU 0.0
               PlotColor HOLD $GphInfo(White) OFF
            } else {
               set xC [expr $R * cos($A)]
               set yC [expr $R * sin($A)]
               set dX [expr $xC - $xO]
               set dY [expr $yC - $yO]
               set dR [expr $dX * $dX + $dY * $dY]
               if { $dR > $hC2 } {
                  TexT $wN $xC $yC 0.0 center + $GphInfo(White)
                  set xO $xC
                  set yO $yC
               }
            }
         }
      }
   }
}
