package provide GMEPlot 1.0

# THIS puts up an ION inversion plot

proc PlotMAP { pN iD pT eS gInfo } {
   global gmANS GphInfo env

   upvar $gInfo gI 

   switch -exact -- $iD {
      MENA  { set gID mG$eS  ; set eID M$eS   ; set cI $gmANS(cION)   }
      HENA  { set gID hG$eS  ; set eID H$eS   ; set cI $gmANS(cION)   }
      RATIO { set gID rG$eS  ; set eID R$eS   ; set cI $gmANS(cRATIO) }
      MOM   { 
          set C [string index $eS 1]
          set gID ${eS}G ; set eID $eS ; set cI $gmANS(cMOM$C)
      }
   }

   InOutList TOARRAY G gmANS($gID) [expr $gI(4) * $gI(5)]

   DefinePlot $pN $pN
   if { $gmANS(Zoom) >= .9 } { set tS 10 } else { set tS 8 }

   for { set I 0 } { $I < 5 } { incr I } {
      set cMAP($I) [lindex $gmANS($cI) $I]
   }
   
   if [string match RECT $pT] {
      TUgridInfo 30 gI vX
      TUgridInfo 31 gI vY
      Plot3D $pN Xb Yb vX vY G MANUAL gI cMAP
   } else {
      set PoPs(0) 1
      PolarPlot $pN PP PP G gI PoPs cMAP 
   }

   PlotColor HOLD 0 0
   Arc $pN 0.0 0.0 0.0 $gmANS(ionLow) 0.0 360.0 1 0 1.0
   PlotColor HOLD 255 OFF

   TextProp 10
   TexT $pN 0.0 0.0 0.0 center $eID $GphInfo(White)
   TextProp 12

   PLTinfoChg $pN ALL NUMBERS NSIZE $tS
   PLTinfoChg $pN ALL NUMBERS TSIZE $tS
   PLTinfoChg $pN Xt NUMBERS TSIZE 10
   if { $pN == $gmANS(AnnPlot) } {
      PlotOutlines $pN [list "X SM" 0.5 "Y SM" 1] [list BOT BOT BOTH BOTH]
   } else {
      PlotOutlines $pN [list "" 1 "" 1] [list NONE NONE BOTH BOTH]
   }
   update
}
