package provide GMEPlot 1.0

# THIS procedure reads in the option file

proc Moments2D { dFunc eSa eSb nP Mass Method dCut ReT } {
   global PI

   upvar $dFunc dF
   upvar $ReT MoM

   set ToVcm [expr 2.0 * 1.6e-12 / $Mass]
   set PT    [expr 4.0 * $PI]

   set MoM(Den) 0.0
   set MoM(VsQ) 0.0

   switch -exact -- $Method {
      CENTERS {
         upvar $eSa eC

         for { set I 0 } { $I < $nP } { incr I } {
            set vC($I) [expr sqrt($ToVcm * $eC($I))]
         }

         for { set I 0 ; set J 1 } { $J < $nP } { incr I ; incr J } {
            set f1  [expr $PT * $vC($I) * $vC($I) * $dF($I)]
            set f2  [expr $PT * $vC($J) * $vC($J) * $dF($J)]
            set dV  [expr $vC($J) - $vC($I)]
            set df  [expr $f2 - $f1]
            set MoM(Den) [expr $MoM(Den) +  $dV * $f1 + .5 * $df * $dV]
                                                                                
            set f1  [expr $vC($I) * $vC($I) * $f1]
            set f2  [expr $vC($J) * $vC($J) * $f2]
            set df  [expr $f2 - $f1]
            set MoM(VsQ) [expr $MoM(VsQ) +  $dV * $f1 + .5 * $df * $dV]
         }
      }
      WIDTHS  {
         upvar $eSa bE
         upvar $eSb eE

         for { set I 0 } { $I < $nP } { incr I } {
                                                                                
# COMPUTE AVERAGE DENSITY (F * INT V^3)

            set vB   [expr sqrt($ToVcm * $bE($I))]
            set vE   [expr sqrt($ToVcm * $eE($I))]
            set vB3  [expr $vB * $vB * $vB]
            set vE3  [expr $vE * $vE * $vE]
            set Vol  [expr $PT * ($vE3  - $vB3) / 3.0]
            set MoM(Den) [expr $MoM(Den) + $dF($I) * $Vol]

# COMPUTE AVERAGE VELOCITY SQUARED (F * INT V^4)

            set Vol [expr $PT * ($vE * $vE * $vE3  - $vB * $vB * $vB3) / 5.0]
            set MoM(VsQ) [expr $MoM(VsQ) + $dF($I) * $Vol]
         }
      }
   }

# COMPUTE AVERAGE TEMPERATURE AND ENERVY in eV 

   if { $MoM(Den) < $dCut } {
      set MoM(VsQ) 0.0
      set MoM(TmP) 0.0
      set MoM(AeV) 0.0
   } else {
      set MoM(VsQ) [expr $MoM(VsQ) / $MoM(Den)]
      set MoM(TmP) [expr 2.0 * $MoM(VsQ) / $ToVcm / 3.0 ]
      set MoM(AeV) [expr $MoM(VsQ) / $ToVcm ]
   }
}
