package provide GMEPlot 1.0

# THIS gets the DMSP orbit track if there is a DMSP overlay

proc MoMOrbTrackPlot { } {
   global gmANS env 

# SEE if we need to put up a cut through an EUV inversion plot

   set pI [PlotCheck 60 69]
   set nP [llength $pI]
   if { $nP == 0 } { return }
   set nE $gmANS(nOrbit)

   GridParams gIM MOMENTS 
   GridParams gI 2D 
   TUgridInfo 32 gI xC
   set tY(0) 0.0
   set EnD [expr $gI(4) - 1] 
   set tG [expr $gIM(4) * $gIM(5)]

   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pI $I] "|"]
      set wN [lindex $tP 0]
      set yA [lindex $tP 1]
      set Q  [lindex $tP 2]
      if [string match Yb $yA] {
         set pC $gmANS(clh)
      } else { set pC $gmANS(crh) }

      set Pri -1
      set Sec ""
      switch -exact -- $Q {
         60 { set Pri FDG                  }
         61 { set Pri FTG                  }
         62 { set Pri MDG                  }
         63 { set Pri MTG                  }
         64 { set Pri HDG                  }
         65 { set Pri HTG                  }
         66 { set Pri MDG ; set Sec HDG    }
         67 { set Pri MTG ; set Sec HTG    }
      }

      set MinR $gmANS(ionLow)
      if { $Pri >= 0 } {
         InOutList TOARRAY GriD gmANS($Pri) $tG
	 OrbitTrackData CUT MOM GriD V $MinR 0.0 XY gIM
         if [string match Yb $yA] {
            set pC $gmANS(clh)
         } else { set pC $gmANS(crh) }
         Plot2D $wN Xb $yA xC V 0 $EnD LINE [list $pC <= 0.0]
      }

      set nS [llength $Sec]
      if { $nS > 0 } {
         for { set J 0 } { $J < $nS } { incr J } {
            set eC [lindex $Sec $J]
            set pC $gmANS(cex$gmANS(pN${wN}eC))
            incr gmANS(pN${wN}eC)
            InOutList TOARRAY GriD gmANS($Sec) $tG
	    OrbitTrackData CUT MOM GriD V $MinR 0.0 XY gIM
            Plot2D $wN Xb $yA xC V 0 $EnD LINE [list $pC <= 0.0]
         }
         lappend gmANS(Q$Q) $pC
      }
   }
   update
}
