package provide GMEPlot 1.0

# THIS gets the DMSP orbit track if there is a DMSP overlay

proc MENAOrbTrackPlot { } {
   global gmANS env RtoD gIM

# SEE if we need to put up a cut through an EUV inversion plot

   set pI [PlotCheck 30 39]
   set nP [llength $pI]
   if { $nP == 0 } { return }
   set nE $gmANS(nOrbit)
   set tG [expr $gIM(4) * $gIM(5)]

   GridParams gI 2D 
   TUgridInfo 32 gI xC
   set EnD [expr $gI(4) - 1] 

   for { set I 0 } { $I < $nP } { incr I } {
      set tP [split [lindex $pI $I] "|"]
      set wN [lindex $tP 0]
      set yA [lindex $tP 1]
      set Q  [lindex $tP 2]
      if [string match Yb $yA] {
         set pC $gmANS(clh)
      } else { set pC $gmANS(crh) }

      set Pri -1
      set Sec ""
      switch -exact -- $Q {
         30 -
         31 -
         32 -
         33 { set Pri [exper $Q - 30]          }
         34 { set Pri 0 ; set Sec 2            }
         35 { set Pri 1 ; set Sec 3            }
         36 { set Pri 0 ; set Sec [list 1 2 3] }
      }

      set MinR $gmANS(ionLow)
      if { $Pri >= 0 } {
         if { [lsearch $gmANS(AVAILMENA) $Pri] >= 0 } {
	    InOutList TOARRAY GriD gmANS(mG$Pri) $tG
	    OrbitTrackData CUT MENA GriD V $MinR 0.0 XY gIM
            if [string match Yb $yA] {
               set pC $gmANS(clh)
            } else { set pC $gmANS(crh) }
            Plot2D $wN Xb $yA xC V 0 $EnD LINE [list $pC < 0.5]
         }
      }
      set nS [llength $Sec]
      if { $nS > 0 } {
         for { set J 0 } { $J < $nS } { incr J } {
            set eC [lindex $Sec $J]
            set pC $gmANS(cex$gmANS(pN${wN}eC))
            incr gmANS(pN${wN}eC)
            if { [lsearch $gmANS(AVAILMENA) $eC] >= 0 } {
	       InOutList TOARRAY GriD gmANS(mG$eC) $tG
	       OrbitTrackData CUT MENA GriD V $MinR 0.0 XY gIM
               Plot2D $wN Xb $yA xC V 0 $EnD LINE [list $pC < 0.5]
            }
            lappend gmANS(Q$Q) $pC
         }
      }
   }
   update
}
