package provide GMEPlot 1.0

proc LinFit { } {
   global gmANS GphInfo eV dF PI

   set pN $gmANS(curSpN)
   set sN $gmANS(sN)

   if { ($gmANS(MHomits) == 2) || ($gmANS(MHomits) == 3) } {
       set ReT [FormXY eV dF oX oY mAV hAV]
       set mE [lindex $ReT 1]
       set hB [lindex $ReT 1]
       set hE [lindex $ReT 0]
       upvar 0 oX iX
       upvar 0 oY iY
   } else {
       set mE [llength $gmANS(AVAILMENA)]
       set hB [llength $gmANS(AVAILMENA)]
       set hE [expr $hB + [llength $gmANS(AVAILHENA)]]
       upvar 0 eV iX
       upvar 0 dF iY
   }
        
   set nC 2

   if { $mE > 1 } { set EnD $mE } else { set EnD [expr $mE + 1] }

   for { set I 0 } { $I < $EnD } { incr I } {
      set MyX($I) $iX($I) 
      set MyY($I) [expr log($iY($I))]
   }

   set cSM [ TUdataLSq1D MyX MyY $EnD 0 cFM icF 2 CoV TUpolyFunc ]

   set cFM(0) [expr exp($cFM(0))]
   set cFM(1) [expr -1.0 / $cFM(1)]

   set nP 0
   for { set I $hB } { $I < $hE } { incr I } {
      set simY [expr $cFM(0) * exp (-$iX($I) / $cFM(1))]
      set dY [expr $iY($I) - $simY]
      set dR [expr $dY / $iY($I)]
      if { ($dY > 0.0) && ($dR > .85) } {
         set MyX($nP) $iX($I) 
         set MyY($nP) [expr log($iY($I))]
         incr nP
      }
   }

   if { $nP > 1 } {
      set cSH [ TUdataLSq1D MyX MyY $nP 0 cFH icF 2 CoV TUpolyFunc ]
      set cFH(0) [expr exp($cFH(0))]
      set cFH(1) [expr -1.0 / $cFH(1)]
   } else {
      set cFH(0) 0.0
      set cFH(1) 100000.0
   }

   for { set I 0 } { $I < 79 } { incr I } {
      set E  [expr double($I + 1)] 
      set X($I) $E
      set Y($I) [expr $cFM(0) * exp(-$E/$cFM(1)) + $cFH(0) * exp(-$E/$cFH(1))]
   }

   if [string match YES $gmANS(showFIT)] {
      set W .sWin$pN
      SetScreen 1 $W.sp
      PlotColor HOLD $GphInfo([lindex $gmANS(pCol) $gmANS(curCP)]) HOLD
      set GphInfo(tag) XY[expr $sN - 1]
      Lines $pN X Y X $I
      set GphInfo(tag) ""
      SetScreen 0 NONE
   }

   if { $gmANS(curC) >= 0 } {
      set State [lindex $gmANS(sPS) $gmANS(curC)] 
      if [string match OPEN $State] { return }
   } else { return }

   if { $gmANS(momID) == 0 } {

      set cDM [expr 1.67e-24 / 1.602e-12 / $PI / 2000.0 / $cFM(1)]
      set cDM [expr $cFM(0) / $cDM / sqrt($cDM)]
      set cDH [expr 1.67e-24 / 1.602e-12 / $PI / 2000.0 / $cFH(1)]
      set cDH [expr $cFH(0) / $cDH / sqrt($cDH)]

      set P $gmANS(curC)
      if { $P >= 0 } {
         set C [lindex $gmANS(gCol) $gmANS(curCP)]
         $W.info.r2c$P delete 0 end
         $W.info.r2c$P insert end [format "%6.2f D1" $cDM]
         $W.info.r2c$P configure -fg $C
         $W.info.r3c$P delete 0 end
         $W.info.r3c$P insert end [format "%6.2f T1" $cFM(1)]
         $W.info.r3c$P configure -fg $C
         $W.info.r4c$P delete 0 end
         $W.info.r4c$P insert end [format "%6.2f D2" $cDH]
         $W.info.r4c$P configure -fg $C
         $W.info.r5c$P delete 0 end
         $W.info.r5c$P insert end [format "%6.2f T2" $cFH(1)]
         $W.info.r5c$P configure -fg $C
      }
   }
}
