package provide GMEPlot 1.0

# THIS procedure sets up the windows for the lineplots

proc LPOutlines { } {
   global gmANS GphInfo oMLT oGLAT

# GET the last wind w opened up for the 2D plots and set the current
#   window number to the next

   set wN [expr [lindex $gmANS(pNs) end] + 1]
   set LastWn [expr $wN + $gmANS(TotalLP) - 1]
   set xMx [expr abs($gmANS(pMax))]

# PUT up the labels over the first plot
# THIS is the time

    set TimE [format "%d %03d %02d:%02d:%02d TO %d %03d %02d:%02d:%02d" \
       $gmANS(bYr) $gmANS(bDy) $gmANS(bHr) $gmANS(bMn) $gmANS(bSc) \
       $gmANS(eYr) $gmANS(eDy) $gmANS(eHr) $gmANS(eMn) $gmANS(eSc) ]

# THIS is the Spacecraft/Hemisphere/MLT label
                                                                                
    set nO [expr int($gmANS(nOrbit) / 2)]
    set MlT $oMLT($nO)
    if { $oGLAT($nO) < 0 } { set HeMi S } else { set HeMi N }
    set ToPLab [format "SAT: %s    HEMISPHERE: %s     MLT: %.2f" \
       $gmANS(DMSPsat) $HeMi $MlT]

# UP the Time and Spacecraft/Hemisphere/MLT labels

    WinClip $wN 0
    if { $gmANS(Zoom) >= .9 } { set tS 10 } else { set tS 8 }
    PLTinfoChg $wN Xt NUMBERS TSIZE $tS
    PLTinfoChg $wN Xt  NUMBERS TCOLOR $GphInfo(White)
    set nOps [list NONE NONE NONE NONE]
    set tOps [list "" -1.0 "" 1 $TimE 4.25]
    PlotOutlines $wN $tOps $nOps
    set tOps [list "" 1 "" 1 $ToPLab 2.25]
    PlotOutlines $wN $tOps $nOps

# NOW throw up all the plot annotation
    set pN 0
    for { set I 0 } { $I < $gmANS(nLP) } { incr I } {
       if { $gmANS(LP${I}Q) > 0 } {
          WinClip $wN 0
          if { $wN == $LastWn } { 
             set dxN BOT 
             set xLab L-Shell
         } else { 
             set dxN NONE 
             set xLab ""
         }
         if { $gmANS(LP${I}Q) == 2 } { set dyN BOTH } else { set dyN BOT }
  
         set LaB [list $xLab 1 "" 1]
         set NuM [list $dxN $dyN BOTH BOTH]

         PLTinfoChg $wN ALL NUMBERS NSIZE $tS
         PLTinfoChg $wN ALL NUMBERS TSIZE $tS
         PLTinfoChg $wN X TICKS MJNUMBER [expr int($xMx) - 1]
         PLTinfoChg $wN Y TICKS MJNUMBER 5
         PLTinfoChg $wN Y TICKS MNNUMBER 5

         PlotOutlines $wN $LaB $NuM
         set cSx [GPHtextLen A X]

         set Q $gmANS(Q${I}0)
         set pLabs [lindex [LPplotLabels $Q] 0]
         set sLab [split $pLabs ":"] 
         set nL [llength $sLab]
         PLTinfoChg $wN Xt  NUMBERS TCOLOR $gmANS(clh)
         set TxT [lindex $sLab 0]
         PLTaxisRec $wN Xt NONE AXIS 0.0 1.0 right $TxT
         set nS [expr [llength $TxT] - 1]
         set xP [expr 1.0 + [GPHtextLen $TxT X] + (1. + $nS) * $cSx]
         for { set J 1 ; set K 0} { $J < $nL } { incr J ; incr K } {
            PLTinfoChg $wN Xt  NUMBERS TCOLOR [lindex $gmANS(Q$Q) $K]
            set TxT [lindex $sLab $J]
            PLTaxisRec $wN Xt NONE AXIS 0.0 $xP right $TxT
            set nS [expr [llength $TxT] - 1]
            set xP [expr $xP + [GPHtextLen $TxT X] + (1. + $nS) * $cSx]
         }

         set Q $gmANS(Q${I}1)
         set pLabs [lindex [LPplotLabels $Q] 0]
         set sLab [split $pLabs ":"] 
         set nL [llength $sLab]
         PLTinfoChg $wN Xt  NUMBERS TCOLOR $gmANS(crh)
         set TxT [lindex $sLab 0]
         PLTaxisRec $wN Xt NONE AXIS 0.0 $xMx left $TxT
         set nS [expr [llength $TxT] - 1]
         set xP [expr $xMx - [GPHtextLen $TxT X] - (1. + $nS) * $cSx]
         for { set J 1 ; set K 0} { $J < $nL } { incr J ; incr K } {
            PLTinfoChg $wN Xt  NUMBERS TCOLOR [lindex $gmANS(Q$Q) $K]
            set TxT [lindex $sLab $J]
            PLTaxisRec $wN Xt NONE AXIS 0.0 $xP left $TxT
            set nS [expr [llength $TxT] - 1]
            set xP [expr $xP - [GPHtextLen $TxT X] - (1. + $nS) * $cSx]
         }

         incr wN
      }
   }
}
