package provide GMEPlot 1.0

# THIS procedure reads in the option file

proc GridParams { gInfo iD } {
   global gmANS PI

   upvar $gInfo gI

   set gI(6)  BAND
   set gI(7)  BAND
   set gI(8)  COLUMN     
   set gI(9)  IGNORE     
   set gI(10) NEW:ADD:END
   set gI(11) 0.0        
   set gI(12) -1.0e31
   set gI(13) -1.0e30
   set gI(14) 1.0e30
   set gI(15) NO
   set gI(16) NO

   switch -exact -- $iD {
      HENA {
          set gI(0)  [expr -$PI]
          set gI(1)  $PI
          set gI(2)  1.2
          set gI(3)  10.8
          set gI(4)  20
          set gI(5)  40
          set gI(15) YES
      }
      MENA {
         set gI(0)  $gmANS(gMin)
         set gI(1)  $gmANS(gMax)
         set gI(2)  $gmANS(gMin)
         set gI(3)  $gmANS(gMax)
         set gI(4)  140
         set gI(5)  140
      }
      RATIO -
      MOMENTS {
         set gI(0)  $gmANS(gMin)
         set gI(1)  $gmANS(gMax)
         set gI(2)  $gmANS(gMin)
         set gI(3)  $gmANS(gMax)
         set gI(4)  120
         set gI(5)  120
         set gI(6)  POINT
         set gI(7)  POINT
      }
      2D  {
          set gI(0)  1.0
          set gI(1)  [expr abs($gmANS(pMax))]
          set gI(2)  -1.0
          set gI(3)  1.0
          set gI(4)  500
          set gI(5)  1
          set gI(6)  POINT
          set gI(7)  POINT
      }
      TIME  {
          set bT [list $gmANS(bYr) $gmANS(bDy) $gmANS(bMs) 0]
          set eT [list $gmANS(eYr) $gmANS(eDy) $gmANS(eMs) 0]
          set gI(0)  [TUtimeConv $bT $bT 0 gmANS(Base)]
          set gI(1)  [TUtimeConv $bT $eT 0 gmANS(Base)]
          set gI(2)  -1.0
          set gI(3)  1.0
          set gI(4)  500
          set gI(5)  1
          set gI(6)  POINT
          set gI(7)  POINT
      }
      ETIME  {
          set cT [list $gmANS(bYr) $gmANS(bDy) $gmANS(bMs) 0]
          set bT [list $gmANS(sY) $gmANS(sD) $gmANS(sMs) 0]
          set eT [list $gmANS(fY) $gmANS(fD) $gmANS(fMs) 0]
          set gI(0)  [TUtimeConv $cT $bT 0 gmANS(Base)]
          set gI(1)  [TUtimeConv $cT $eT 0 gmANS(Base)]
          set gI(2)  -1.0
          set gI(3)  1.0
          set gI(4)  [expr int(($gI(1) - $gI(0)) / $gmANS(SdT))]
          set gI(5)  1
          set gI(6)  POINT
          set gI(7)  POINT
      }
   }
}
