package provide GMEPlot 1.0

# THIS produces moment maps.

proc GlobalMom { gX gY gD gT gmD gmT ghD ghT } {
   global gmANS gIH gIM

   upvar $gD  tD
   upvar $gT  tT
   upvar $gmD mD
   upvar $gmT mT
   upvar $ghD hD
   upvar $ghT hT

   set ConV 5.448e-28

   if { $gmANS(pMin) > $gmANS(pMax) } { 
      set Min $gmANS(pMax)
      set Max $gmANS(pMin)
   } else {
      set Min $gmANS(pMin)
      set Max $gmANS(pMax)
   }

   set T [expr int(($Max) - $Min) / $dR)]
   set dR [expr ($Max - $Min) / $T]

   set N 0
   set X $Min
   set Y $Min
   while { $X <= $Max } { 
      while { $Y <= $Max } { 
         set gX($N) $X
         set gY($N) $Y
         set CnT 0
         TUgridInfo 0 gIM rV $X $Y
         set nP [llength $gmANS(AVAILMENA)]
         for { set I 0 } { $I < $nP } { incr I } {
            set J  [lindex $gmANS(AVAILMENA) $I] 
            set bE [lindex $gmANS(MbE) $I] 
            set eE [lindex $gmANS(MeE) $I] 
            set aE [expr ($bE + $eE)/2.0]
 
            set tX($CnT) [expr $aE / 1000.0]
            set tY($CnT) [expr [lindex $gmANS(mG$J) $rV(0)] * $ConV / $aE]
            incr CnT
         }
	 set eM $CnT

         set xH [expr atan2($X , $Y)]
         set yH [expr sqrt($X *$X +  $Y *$Y)]

         TUgridInfo 0 gIH rV $xH $yH

         set HcnT 0
         set nP [llength $gmANS(AVAILHENA)]
         for { set I 0 } { $I < $nP } { incr I } {
            set J  [lindex $gmANS(AVAILHENA) $I] 
            set bE [lindex $gmANS(HbE) $J] 
            set eE [lindex $gmANS(HeE) $J] 
            set aE [expr ($bE + $eE)/2.0]

            set tX($CnT) [expr $aE / 1000.0]
            set tY($CnT) [expr [lindex $gmANS(hG$J) $rV(0)] * $ConV / $aE]
            set hX($HcnT) $tX($CnT)
            set hY($HcnT) $tY($CnT)
            incr CnT
         }
	 set eH $HcnT
         set Y [expr $Y + $dR]
         Moments2D tY tX tX $CnT $Mass CENTER .01 mT 
         Moments2D tY tX tX $eM  $Mass CENTER .01 mM 
         Moments2D hY hX hX $eH  $Mass CENTER .01 mH 
      }
      set X [expr $X + $dR]
   }

   set dV [llength $gmANS(RetMom)]
   for { set I 0 } { $I < $nP } { incr I } {
      set dMom [lindex $gmANS(RetMom) $I] 
      switch -exact -- $dMom {
         TD { set tD($N) $mT(Den) }
         MD { set mD($N) $mM(Den) }
         HD { set hD($N) $mH(Den) }
         TT { set tT($N) $mT(TmP) }
         MT { set mT($N) $mM(TmP) }
         HT { set hT($N) $mH(TmP) }
      }
   }
}
