package provide GMEPlot 1.0

# THIS puts up an EUV simulation plot

proc GetSpectra { eV dF { xP -2000.0 } { yP -2000.0 } } {
   global gmANS gIH gIM

   upvar $eV X
   upvar $dF Y

   if { $xP < -1000.0 } { set xP $gmANS(sX) ; set yP $gmANS(sY) }

   set ConV 5.448e-28
   set CnT 0

   set nP [llength $gmANS(AVAILMENA)]
   TUgridInfo 0 gIM rV $xP $yP
   for { set I 0 } { $I < $nP } { incr I } {
      set J  [lindex $gmANS(AVAILMENA) $I] 
      set bE [lindex $gmANS(MbE) $I] 
      set eE [lindex $gmANS(MeE) $I] 
      set aE [expr ($bE + $eE)/2.0]

      set X($CnT) [expr $aE / 1000.0]
      set Y($CnT) [expr [lindex $gmANS(mG$J) $rV(0)] * $ConV / $aE]
      incr CnT
   }

   set xH [expr atan2($yP , $xP)]
   set yH [expr sqrt($xP * $xP + $yP * $yP)]

   TUgridInfo 0 gIH rV $xH $yH

   set nP [llength $gmANS(AVAILHENA)]
   for { set I 0 } { $I < $nP } { incr I } {
      set J  [lindex $gmANS(AVAILHENA) $I] 
      set bE [lindex $gmANS(HbE) $J] 
      set eE [lindex $gmANS(HeE) $J] 
      set aE [expr ($bE + $eE)/2.0]

      set X($CnT) [expr $aE / 1000.0]
      set Y($CnT) [expr [lindex $gmANS(hG$J) $rV(0)] * $ConV / $aE]
      incr CnT
   }
}
