/*  The C equivalent of FfT,  It consists of a TCL interface over a         */
/*  straight C subroutine                                                   */
/*                                                                          */
/*  There are 4 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Data array                                                 */
/*     OBJV[2]:  Length of data array                                       */
/*     OBJV[3]:  Array type Flag                                            */
/*                   1 - data array is real                                 */
/*                  -1 - data array is complex                              */


#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TfftAnsi.h"
#include "TutilAnsi.h"
                                                                                
int FfTCmd (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv)
{
   void *memPtr = NULL;
   ReaL_8 *V;
   int nP, tnP, dFlg, Bytes;
   ByTe_4 rV;
                                                                                
/* Make sure that all the IO parameters are present */
                                                                                
   if (objc != 4 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: FfT Data nP DataType");
     return TCL_ERROR;
   }
                                                                                
/* Get the non-array inputs                                              */
                                                                               
   Tcl_GetIntFromObj (tI, objv[2], &nP);
   Tcl_GetIntFromObj (tI, objv[3], &dFlg);
   tnP = 2 * nP;
                                                                                
/*  MALLOC memory to hold the data array                                 */
                                                                                
   Bytes = sizeof(ReaL_8) * tnP;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   V = (ReaL_8 *)memPtr;

/*  TRANSFER the data                                                    */

   if (TclArrayToC (tI, objv[1], (void *)V, tnP, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }
 
/* CALL the C routine                                                    */

  rV =  FfTCmd_C (V, nP, dFlg);

/* DATA ARRAY back to Tcl                                                */

  CArrayToTcl (tI, objv[1], V, tnP, 0, 'D');
                                                                                
/* Get rid of the temporary array and return                             */
                                                                                
   free (memPtr);
   return TCL_OK;
}

                                                                                
/* THE C ROUTINE                                                         */
                                                                                
                                                                                
ByTe_4 FfTCmd_C (ReaL_8 *V,  int nP, int dFlg)
{
   ReaL_8 TwoPI = 6.28318530717958647692;
   ReaL_8 TmP, ThetA, pR, pI, Re, Im, rTmP, iTmP;
   ByTe_4 I, J, K, L, M;
   ByTe_4 MaX, SteP;

   nP = nP << 1;

   J = 0;
   L = 1;
   for (I = 0, K = 1;  I < nP; I += 2,  K += 2 ) {
      if (J > I) {
         TmP = V[J];
         V[J] = V[I];
         V[I] = TmP;
         TmP = V[K];
         V[K] = V[L];
         V[L] = TmP;
      }
      M = nP >> 1;

      while ( (M >= 2) && (J >= M) ) {
         J = J - M;
         M = M >> 1;
      }
      J += M;
      L = J + 1;
   }

   MaX = 2;
   while ( nP > MaX ) {
      SteP = MaX << 1;
      ThetA = dFlg * TwoPI / MaX;
      TmP = sin(0.5 * ThetA);
      pR = -2.0 * TmP * TmP;
      pI = sin(ThetA);
      Re = 1.0;
      Im = 0.0;
      for ( M = 0;  M < MaX; M += 2 ) {
         for ( I = M;  I < nP; I += SteP ) {
             J = I + MaX;
             K = J + 1;
             L = I + 1;
             rTmP = Re * V[J] - Im * V[K];
             iTmP = Re * V[K] + Im * V[J];
             V[J] = V[I] - rTmP;
             V[K] = V[L] - iTmP;
             V[I] = V[I] + rTmP;
             V[L] = V[L] + iTmP;
         }

         TmP = Re; 
         Re = Re * pR - Im * pI + Re;
         Im = Im * pR + TmP * pI + Im;
      }
      MaX = SteP;
   }
   return(1);
}
