package provide TclFFT_C 1.0

# MAXIMUM ENTROPY POWER SPECTRUM GENERATOR
#
#    CoeF:  The MEM coefficients
#    nC:    The number of MEM coefficients
#    FqDt:  The frequency times the sampling interval
#    XmS:   Mean Square Error from MemEntCoef
#
#    RETURNS: the power at Fq

proc MaxEntPwr { CoeF nC FqDt XmS } {
  global TwoPI 

   upvar $CoeF   C

   set Theta [expr $TwoPI * $FqDt]
   set wR 1.0
   set wI 0.0
   set wpR [expr cos($Theta)]
   set wpI [expr sin($Theta)]
   set SumR 1.0
   set SumI 0.0

   for { set I 0 } { $I < $nC } { incr I } { 
      set wtR $wR
      set wR [expr $wR * $wpR - $wI * $wpI]
      set wI [expr $wI * $wpR + $wtR * $wpI] 
      set SumR [expr $SumR - $C($I) * $wR]
      set SumI [expr $SumI - $C($I) * $wI]
   }

   set rV [expr $XmS / ($SumR * $SumR + $SumI * $SumI)]
   return $rV
}
