# FFT DATA CONVOLUTION or DECONVOLUTION ROUTINE
#
#  Inputs   DataI    :  Input data array
#           nP       :  Number of points in data array
#           ResonseF :  Response function in wraparound order
#           nR       :  Response function length
#           Dir      :  Direction  (CONVOLVE or DECONVOLVE)
#           DataO    :  Output data array
#           
#

package provide TclFFT_C 1.0

proc FfTConvolve { DataI nP ResponseF nR Dir DataO } {
 
   upvar $DataI iD
   upvar $DataO oD
   upvar $ResponseF rF

   set EnD [expr ($nR -1)/2 ] 

   for { set I 0 } { $I < $EnD } { incr I } {
      set J [expr $nP - 1 - $I]
      set K [expr $nR - 1 - $I]
      set rF($J) $rF($K)
   }

   set EnD [expr $nP - $EnD ] 
   set BeG [expr ($nR + 3)/2  - 1] 
   for { set I $BeG } { $I < $EnD } { incr I } { set rF($I) 0.0 }

   TwoFfT iD rF TmP oD $nP
   
   set hP [expr double($nP >> 1)]
   set EnD [expr $nP + 2] 
   if [string match CONVOLVE $Dir] {
     for { set I 0 ; set J 1 } { $I < $EnD } { incr I 2 ; incr J 2 } {
        set T $oD($I)
        set oD($I) [expr ($TmP($I) * $T - $TmP($J) * $oD($J)) / $hP]
        set oD($J) [expr ($TmP($J) * $T + $TmP($I) * $oD($J)) / $hP]
     }
   } else {
     for { set I 0 ; set J 1 } { $I < $EnD } { incr I 2 ; incr J 2 } {
        set MaG [expr $hP * ($oD($I) * $oD($I) - $oD($J) * $oD($J))]
        if { $MaG == 0.0 } { 
           puts stderr "ZERO RESPONSE IN FfTConvolve"
           return -1
        }
        set T $oD($I)
        set oD($I) [expr ($TmP($I) * $T + $TmP($J) * $oD($J))/$MaG]
        set oD($J) [expr ($TmP($J) * $T - $TmP($I) * $oD($J))/$MaG]
     }
   }
   
   set oD(1) $oD($nP)

   RealFfT oD $nP -1

   return 1
}
