/*  The C equivalent of MaxEntCoef,  It consists of a TCL interface over a  */
/*  straight C subroutine                                                   */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Coefficient array                                          */
/*     OBJV[2]:  Number of coefficients                                     */
/*     OBJV[3]:  The frequency times the sampling interval                  */
/*     OBJV[4]:  Mean square error                                          */


#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TfftAnsi.h"
#include "TutilAnsi.h"
                                                                                
int MxEntPCmd (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv)
{
   void *memPtr = NULL;
   ReaL_8 *C;
   int nC, Bytes;
   ReaL_8 FqDt, XmS;
   ReaL_8 rV;

   Tcl_Obj *objPtr;
                                                                                
/* Make sure that all the IO parameters are present */
                                                                                
   if (objc != 5 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: FfT Data nP DataType");
     return TCL_ERROR;
   }
                                                                                
/* Get the non-array inputs                                              */
                                                                               
   Tcl_GetIntFromObj (tI, objv[2], &nC);
   Tcl_GetDoubleFromObj (tI, objv[3], &FqDt);
   Tcl_GetDoubleFromObj (tI, objv[4], &XmS);
                                                                                
/*  MALLOC memory to hold the data array                                 */
                                                                                
   Bytes = sizeof(ReaL_8) * nC;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   C = (ReaL_8 *)memPtr;

/*  TRANSFER the data                                                    */

   if (TclArrayToC (tI, objv[1], (void *)C, nC, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }
 
/* CALL the C routine                                                    */

  rV =  MxEntPCmd_C (C, nC, FqDt, XmS);

/* Get rid of the temporary array and return                             */
                                                                                
   free (memPtr);

/* Return the mean square error                                          */

   objPtr = Tcl_GetObjResult(tI);
   Tcl_SetDoubleObj (objPtr, rV);
   return TCL_OK;
}

                                                                                
/* THE C ROUTINE                                                         */
                                                                                
                                                                                
ReaL_8 MxEntPCmd_C(ReaL_8 *C, int nC, ReaL_8 FqDt, ReaL_8 XmS)
{
   ReaL_8 TwoPI = 6.28318530717958647692;
   ReaL_8 SumR, SumI, wR, wI, Theta, wpR, wpI, wtR;
   ReaL_8 rV;
   ByTe_4 I;

   Theta = TwoPI * FqDt;
   wR = 1.0;
   wI = 0.0;
   wpR = cos(Theta);
   wpI = sin(Theta);
   SumR = 1.0;
   SumI = 0.0;

   for (I = 0;  I < nC; ++I) { 
      wtR = wR; 
      wR = wR * wpR - wI * wpI;
      wI = wI * wpR + wtR * wpI;
      SumR -= C[I] * wR;
      SumI -= C[I] * wI;
   }
   rV = XmS / (SumR * SumR + SumI * SumI);
   return(rV);
}
