# THIS procedure runs up each column in the density matrix and zeros out
#   all elements after finding more than a preset number of empty grids.
#
# NOTE - you cannot do this type of noise reduction on solution grids
#    which use an XY format.

package provide EUVSim 1.0

proc ZeroSolScrub { zI } {
   global gHDM euvANS

   upvar $zI zImG

# IF we need to despeckle this beast then do it here

   if { $euvANS(zdeSpeck) == 1 } {
      for { set I 0 } { $I < $euvANS(zspRep) } { incr I } {
         TUgridNoise DESPECKLE zImG gHDM $euvANS(zspeckN) $euvANS(zspMin) 0.0
      }
   }

# IF the zero matrix is in polar format then we can do a radial scrubbing
#    of the matrix.  If there is no radial scrubbing to do or if this is
#    a rectangular matrix we are through here.

   if { !$euvANS(srNoise) || [string match XY $euvANS(SolGrid)] } { return } 

# A radial scrubbing consists of walking out along radial arms (the matrix
#    columns) and looking for a break in the column (where the 1's become
#    0's).  If there are a sufficient number of consequtive zeros (this 
#    number is user defined) then the rest of the column is set to 0.

   for { set I 0 } { $I < $gHDM(4) } { incr I } {
      set P [expr 10 * $gHDM(4) + $I]
      set gCnT 0
      for { set J 10 } { $J < $gHDM(5) } { incr J ; incr P $gHDM(4) } {
         if { $zImG($P) < 0.1 } {
            incr gCnT
            if { $gCnT >= $euvANS(zrGrids) } {
               while { $J < $gHDM(5) } { 
                  set zImG($P) 0 
                  incr J
                  incr P $gHDM(4)
               }
            }
         } else { set gCnT 0 }
      }
   }
}
