package provide EUVSim 1.0

proc UserInterface {  } {
  global euvANS env Prefs

# READ in the preference file

   GUIprefsRead
   PlotOptMenu
   GridOptMenu
   MaskOptMenu

# LETS make the labels in the menu bold

   set LFonT [list fixed $Prefs(FontSize) bold]

# LAY out the window names for the GUI frame structure

   set bW .giINFO

   if { [winfo exists $bW] == 0 } {
      toplevel $bW
      wm title . "EUV INVERSION SIMULATION"
      wm withdraw .

      set WiNs [list cmd top menu time opts]
      set Frms [list a b c d e]
      set nF [llength $Frms]

      for { set I 0 } { $I < $nF } { incr I } {
          set W $bW.[lindex $WiNs $I]
          set W[lindex $Frms $I] $W
          GUIFrame $W -1 pack|top||both
      }

      GUIbuttonPush $Wa.quit QUIT pack|right "exit"    6
      GUIbuttonPush $Wa.run  RUN  pack|left  "DoSim"   6
      GUIbuttonPush $Wa.next  NEXT pack|left  "NexT" 6
      GUILabel $Wa.step MENU w pack|left 2 18 "" $LFonT
      GUILabel $Wa.time IDLE w pack|left 2 22 "" $LFonT
      GUIstateSet $Wa.next PBUTTON muted

      for { set I 1 } { $I < $nF } { incr I } {
          set Wl $bW.[lindex $WiNs $I].left
          set Wr $bW.[lindex $WiNs $I].right
          set W[lindex $Frms $I]l $Wl
          set W[lindex $Frms $I]r $Wr
          GUIFrame $Wl 0 pack|left|w
          GUIFrame $Wr 0 pack|right|e
      }

# OUTPUT DEVICE

      GUILabel $Wbl.lab1 "Output To" c grid|0|0 0 0 "" $LFonT
      set Ops [GUdevOpts]
      set Lab [lindex [split [lindex $Ops 0] '|'] 0]
      set euvANS(dev) [lindex [split [lindex $Ops 0] '|'] 1]
      GUIbuttonMenu $Wbl.dev $Lab grid|1|0 $Ops  \
           "GUIoptsProcess $Wbl.dev euvANS(dev) ALT " 6

# COLOR TABLE

      set CtOps [GUctblOpts]
      if ![info exists euvANS(ctbl)] {
         set euvANS(ctbl) [lindex [split [lindex $CtOps 0] '|'] 1 ]
         set CtLab [lindex [split [lindex $CtOps 0] '|'] 0 ]
      } else {
         set CtLab ""
         set nCt [llength $CtOps]
         for { set I 0 } { $I < $nCt } { incr I } {
            set AlT [lindex [split [lindex $CtOps $I] '|'] 1 ]
            if {[string compare $AlT $euvANS(ctbl)] == 0 } {
               set CtLab [lindex [split [lindex $CtOps $I] '|'] 0 ]
               break
            }
         }
         if { [string length $CtLab] == 0 } {
            set euvANS(ctbl) [lindex [split [lindex $CtOps 0] '|'] 1 ]
            set CtLab [lindex [split [lindex $CtOps 0] '|'] 0 ]
         }
      }


      GUILabel $Wbl.lab2 "ColorTable" c grid|0|1 0 0 "" $LFonT
      GUIbuttonMenu $Wbl.ctbl $CtLab grid|1|1 $CtOps  \
           "GUIoptsProcess $Wbl.ctbl euvANS(ctbl) ALT " 6

      GUILabel $Wbl.lab3 "Print Mesh" c grid|0|2 0 0 "" $LFonT
      set Ops [list NO|0 YES|1]
      set Lab [lindex [split [lindex $Ops $euvANS(doPrnt)] "|"] 0]
      GUIbuttonToggle $Wbl.prm $Lab grid|1|2 $Ops \
           "GUIoptsToggle $Wbl.prm euvANS(doPrnt) ALT " 6 

      GUILabel $Wbr.lab1 "" c grid|0|2 0 0 "" $LFonT
      set Lab "Plot Options"
      GUIbuttonPush $Wbr.hem $Lab grid|1|2 "GUIwindowCtrl .giPLOT" 6
      set Wl $Wbr.lab2
      GUILabel $Wl "" c grid|0|1 0 0 "" $LFonT
      set Lab "Grid Options"
      GUIbuttonPush $Wbr.cor $Lab grid|1|1 "GUIwindowCtrl .giCOR" 6
      set Wl $Wbr.lab3
      GUILabel $Wl "" c grid|0|0 0 0 "" $LFonT
      set Lab "Masks"
      GUIbuttonPush $Wbr.msk $Lab grid|1|0 "GUIwindowCtrl .giMASK" 6

      set Row 0

      GUILabel $Wcl.lmif "Input Menu File"  c grid|$Row|0|e 0 0 "" $LFonT
      GUIboxEntry $Wcl.mif grid|$Row|1 40 euvANS(miFile)
      GUIbuttonPush $Wcl.load  LOAD  grid|$Row|2|e "ReadMenu"
      incr Row
      GUILabel $Wcl.lmof "OutPut Menu File" c grid|$Row|0|e 0 0 "" $LFonT
      GUIboxEntry $Wcl.mof grid|$Row|1 40 euvANS(moFile) 
      GUIbuttonPush $Wcl.save  SAVE grid|$Row|2|e "SaveMenu"

      set Row 0
      GUILabel $Wdl.lyy "Year"   c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wdl.ldy "Day"    c grid|$Row|2|ew 0 0 "" $LFonT
      GUILabel $Wdl.lhr "Hour"   c grid|$Row|3|ew 0 0 "" $LFonT
      GUILabel $Wdl.lmn "Minute" c grid|$Row|4|ew 0 0 "" $LFonT
      GUILabel $Wdl.lsc "Second" c grid|$Row|5|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wdl.lbeg "Start Time" c grid|$Row|0|e 0 0 "" $LFonT
      GUIboxEntry $Wdl.begyy grid|$Row|1 7 euvANS(begYr)
      GUIboxEntry $Wdl.begdy grid|$Row|2 7 euvANS(begDy)
      GUIboxEntry $Wdl.beghr grid|$Row|3 7 euvANS(begHr)
      GUIboxEntry $Wdl.begmn grid|$Row|4 7 euvANS(begMn)
      GUIboxEntry $Wdl.begsc grid|$Row|5 7 euvANS(begSc)
      incr Row
      GUILabel $Wdl.lend "Stop Time" c grid|$Row|0|e 0 0 "" $LFonT
      GUIboxEntry $Wdl.endyy grid|$Row|1 7 euvANS(endYr)
      GUIboxEntry $Wdl.enddy grid|$Row|2 7 euvANS(endDy)
      GUIboxEntry $Wdl.endhr grid|$Row|3 7 euvANS(endHr)
      GUIboxEntry $Wdl.endmn grid|$Row|4 7 euvANS(endMn)
      GUIboxEntry $Wdl.endsc grid|$Row|5 7 euvANS(endSc)

      incr Row
      GUIblankRow $Wdl $Row 1.0
      incr Row

      set Ops [list POLAR|PT RECTANGULAR|XY]
      GUILabel $Wel.lgrid "Format" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wel.lxres "X Res"   c grid|$Row|3|ew 0 0 "" $LFonT
      GUILabel $Wel.lyres "Y Res"  c grid|$Row|4|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wel.lsgrid "Solution Grid " c grid|$Row|0|w 0 0 "" $LFonT
      if [string match PT $euvANS(SolGrid)] { 
          set LaB POLAR 
      } else { set LaB RECTANGULAR }
      GUIbuttonMenu $Wel.sgrid $LaB grid|$Row|1|||2 $Ops  \
           "GUIoptsProcess $Wel.sgrid euvANS(SolGrid) ALT " 
      GUIboxEntry $Wel.sxres grid|$Row|3 7 euvANS(xgRes)
      GUIboxEntry $Wel.syres grid|$Row|4 7 euvANS(ygRes)

      incr Row
      GUIblankRow $Wel $Row 1.0
      incr Row

      GUILabel $Wel.lintr "Intg Res" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wel.liter "NIter"   c grid|$Row|2|ew 0 0 "" $LFonT
      GUILabel $Wel.llMax "Max L"   c grid|$Row|3|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wel.lfit "Fit Options" c grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wel.fintr grid|$Row|1 7 euvANS(iRes)
      GUIboxEntry $Wel.fiter grid|$Row|2 7 euvANS(nIter)
      GUIboxEntry $Wel.lMax  grid|$Row|3 7 euvANS(lMax)

      incr Row
      GUIblankRow $Wel $Row 1.0
      incr Row

      GUILabel $Wel.lph "Phase" c grid|$Row|1|ew 0 0 "" $LFonT
      GUILabel $Wel.lth "Elev." c grid|$Row|2|ew 0 0 "" $LFonT
      incr Row
      GUILabel $Wel.lesh Shifts c grid|$Row|0|w 0 0 "" $LFonT
      GUIboxEntry $Wel.ipsh  grid|$Row|1 7 euvANS(phShift)
      GUIboxEntry $Wel.iesh  grid|$Row|2 7 euvANS(thShift)

      incr Row
      GUIblankRow $Wel $Row 2.0
      incr Row

      set Ops [list CONSTANT|0 IMAGE|1 CUSTOM|2]
      set LaB "Lat. Density " 
      GUILabel $Wel.llatden $LaB c grid|$Row|0|w 0 0 "" $LFonT
      set LaB [lindex [split [lindex $Ops $euvANS(LatDenM)] "|"] 0] 
      GUIbuttonMenu $Wel.latden $LaB grid|$Row|1|||2 $Ops  \
           "GUIoptsProcess $Wel.latden euvANS(dev) ALT " 
      GUIboxEntry $Wel.ldfile grid|$Row|3|||6 30 euvANS(LDenF)

   }
   update
   bind  .giINFO.menu.left.mif <Return> \
                       { .giINFO.menu.left.mof delete 0 end ; \
                         .giINFO.menu.left.mof insert end "$euvANS(miFile)"}
}
